/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v2_0.customtransfer;

import com.ericsson.em.m3if.financial.v1_0.common.ExternalInformation;
import com.ericsson.em.m3if.financial.v1_0.quotation.Assistable;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.ClientReferenceIdValue;
import com.ericsson.em.m3if.v1_0.common.CustomDataList;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.ProviderTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.ReceiverMessageValue;
import com.ericsson.em.m3if.v1_0.common.RequestReferenceId;
import com.ericsson.em.m3if.v1_0.common.SenderNoteValue;
import com.ericsson.em.m3if.v1_0.common.Timeout;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v2_0", name="customtransferrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v2_0", name="", propOrder={"transferType", "sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "referenceId", "quoteId", "requestReferenceId", "includeOffNet", "includeSenderCharges", "providerTransactionId", "externalInformation", "customDataList", "reservationTimeout"})
public class CustomTransferRequest
implements Serializable,
QuoteRequest,
Assistable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="transfertype", type=TransferType.class, required=true)
    private TransferType transferType;
    @Valid
    @NotNull
    @XmlElement(name="sendingfri", type=FRIValue.class, required=true)
    private FRIValue sendingFRI;
    @Valid
    @NotNull
    @XmlElement(name="receivingfri", type=FRIValue.class, required=true)
    private FRIValue receivingFRI;
    @Valid
    @NotNull
    @IsPositiveAmount
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="sendernote", type=SenderNoteValue.class, required=false)
    private SenderNoteValue senderNote;
    @Valid
    @XmlElement(name="receivermessage", type=ReceiverMessageValue.class, required=false)
    private ReceiverMessageValue receiverMessage;
    @Valid
    @XmlElement(name="referenceid", type=ClientReferenceIdValue.class, required=false)
    private ClientReferenceIdValue referenceId;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class, required=false)
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="requestreferenceid", type=RequestReferenceId.class, required=false)
    private RequestReferenceId requestReferenceId;
    @XmlElement(name="includeoffnet", type=Boolean.class, required=false, defaultValue="false")
    private Boolean includeOffNet = false;
    @XmlElement(name="includesendercharges", type=Boolean.class, required=false, defaultValue="false")
    private Boolean includeSenderCharges = false;
    @Valid
    @XmlElement(name="providertransactionid", type=ProviderTransactionIdValue.class)
    private ProviderTransactionIdValue providerTransactionId;
    @Valid
    @XmlElement(name="externalinformation", type=ExternalInformation.class)
    private ExternalInformation externalInformation;
    @Valid
    @XmlElement(name="customdatalist", type=CustomDataList.class)
    private CustomDataList customDataList;
    @Valid
    @XmlElement(name="reservationtimeout", type=Timeout.class)
    private Timeout reservationTimeout;

    public CustomTransferRequest() {
    }

    public CustomTransferRequest(TransferType transferType, FRIValue sendingFRI, FRIValue receivingFRI, MoneyDetails amount) {
        this.setTransferType(transferType);
        this.setSendingFRI(sendingFRI);
        this.setReceivingFRI(receivingFRI);
        this.setAmount(amount);
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public FRIValue getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(FRIValue sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public FRIValue getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(FRIValue receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public SenderNoteValue getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(SenderNoteValue senderNote) {
        this.senderNote = senderNote;
    }

    public ReceiverMessageValue getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(ReceiverMessageValue receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public ClientReferenceIdValue getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(ClientReferenceIdValue referenceId) {
        this.referenceId = referenceId;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public RequestReferenceId getRequestReferenceId() {
        return this.requestReferenceId;
    }

    public void setRequestReferenceId(RequestReferenceId requestReferenceId) {
        this.requestReferenceId = requestReferenceId;
    }

    public Boolean getIncludeOffNet() {
        return this.includeOffNet;
    }

    public void setIncludeOffNet(Boolean includeOffNet) {
        this.includeOffNet = includeOffNet;
    }

    public Boolean getIncludeSenderCharges() {
        return this.includeSenderCharges;
    }

    public void setIncludeSenderCharges(Boolean includeSenderCharges) {
        this.includeSenderCharges = includeSenderCharges;
    }

    public ExternalInformation getExternalInformation() {
        return this.externalInformation;
    }

    public void setExternalInformation(ExternalInformation externalInformation) {
        this.externalInformation = externalInformation;
    }

    public ProviderTransactionIdValue getProviderTransactionId() {
        return this.providerTransactionId;
    }

    public void setProviderTransactionId(ProviderTransactionIdValue providerTransactionId) {
        this.providerTransactionId = providerTransactionId;
    }

    public Optional<CustomDataList> getCustomDataList() {
        return Optional.ofNullable(this.customDataList);
    }

    public void setCustomDataList(CustomDataList customDataList) {
        this.customDataList = customDataList;
    }

    public Optional<Timeout> getReservationTimeout() {
        return Optional.ofNullable(this.reservationTimeout);
    }

    public void setReservationTimeout(Timeout reservationTimeout) {
        this.reservationTimeout = reservationTimeout;
    }
}

