/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_5.transfertobankaccount;

import com.ericsson.em.m3if.financial.v1_0.quotation.Assistable;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.approvals.ExpiredApprovalAware;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_3.common.ScheduledTransactionDate;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsIntegerWithinRange;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_5", name="transfertobankaccountrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_5", name="", propOrder={"sendingIdentity", "sendingFRI", "amount", "senderNote", "receiverMessage", "quoteId", "maxNumberOfRetries", "scheduled", "amountThreshold"})
public class TransferToBankAccountRequest
implements Serializable,
QuoteRequest,
ExpiredApprovalAware,
Assistable {
    private static final long serialVersionUID = 1L;
    @Length(max=256)
    @IsIdentity
    @XmlElement(name="sendingidentity")
    private String sendingIdentity;
    @Length(max=256)
    @IsFinancialResourceIdentifier
    @XmlElement(name="sendingfri")
    private String sendingFRI;
    @NotNull
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="sendernote", required=false)
    private String senderNote;
    @Length(max=100)
    @IsRestrictedString
    @XmlElement(name="receivermessage", required=false)
    private String receiverMessage;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class)
    private QuoteId quoteId;
    @IsIntegerWithinRange(min=0)
    @XmlElement(name="maxnumberofretries", required=false)
    private Integer maxNumberOfRetries;
    @Valid
    @XmlElement(name="scheduled", type=ScheduledTransactionDate.class)
    private ScheduledTransactionDate scheduled;
    @XmlElement(name="amountthreshold")
    private Boolean amountThreshold;

    public TransferToBankAccountRequest() {
    }

    public TransferToBankAccountRequest(String sendingIdentity, MoneyDetails amount) {
        this.sendingIdentity = sendingIdentity;
        this.amount = amount;
    }

    public String getSendingIdentity() {
        return this.sendingIdentity;
    }

    public void setSendingIdentity(String sendingIdentity) {
        this.sendingIdentity = sendingIdentity;
    }

    public String getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(String sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public Integer getMaxNumberOfRetries() {
        return this.maxNumberOfRetries;
    }

    public void setMaxNumberOfRetries(Integer maxNumberOfRetries) {
        this.maxNumberOfRetries = maxNumberOfRetries;
    }

    public ScheduledTransactionDate getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(ScheduledTransactionDate scheduled) {
        this.scheduled = scheduled;
    }

    public Boolean getAmountThreshold() {
        return this.amountThreshold;
    }

    public void setAmountThreshold(Boolean amountThreshold) {
        this.amountThreshold = amountThreshold;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    @Override
    public Optional<String> getSendingFri() {
        return Optional.ofNullable(this.sendingFRI);
    }

    @Override
    public Optional<String> getReceivingFri() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getSupplementaryData() {
        return Optional.ofNullable(this.sendingIdentity == null ? null : "Sending identity: " + this.sendingIdentity);
    }
}

