/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_4.common;

import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.v2_1.common.FinancialInstructionType;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import com.ericsson.em.validators.IsAmount;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_4/common", name="financialinstructiondetails", propOrder={"date", "fromFRI", "toFRI", "financialInstructionType", "transferType", "amount", "fromMessage", "toMessage", "externalTransactionId"})
public class ReverseInstruction
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @XmlElement(name="date", required=true)
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date date;
    @IsFinancialResourceIdentifier
    @NotNull
    @XmlElement(name="fromfri", required=true)
    private String fromFRI;
    @IsFinancialResourceIdentifier
    @NotNull
    @XmlElement(name="tofri", required=true)
    private String toFRI;
    @Valid
    @NotNull
    @XmlElement(name="financialinstructiontype", required=true)
    private FinancialInstructionType financialInstructionType;
    @Valid
    @NotNull
    @XmlElement(name="transfertype", required=true)
    private TransferType transferType;
    @XmlElement(name="amount", required=true)
    @IsAmount(allowNull=false)
    private BigDecimal amount;
    @IsRestrictedString
    @XmlElement(name="frommessage")
    private String fromMessage;
    @IsRestrictedString
    @XmlElement(name="tomessage")
    private String toMessage;
    @Length(max=256)
    @IsExternalTransactionIdString
    @XmlElement(name="externaltransactionid", required=false)
    private String externalTransactionId;

    public DateTime getDate() {
        return DateHelper.fromDate(this.date);
    }

    public void setDate(DateTime date) {
        this.date = DateHelper.toDate(date);
    }

    public String getFromFRI() {
        return this.fromFRI;
    }

    public void setFromFRI(String fromFRI) {
        this.fromFRI = fromFRI;
    }

    public String getToFRI() {
        return this.toFRI;
    }

    public void setToFRI(String toFRI) {
        this.toFRI = toFRI;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getFromMessage() {
        return this.fromMessage;
    }

    public void setFromMessage(String fromMessage) {
        this.fromMessage = fromMessage;
    }

    public String getToMessage() {
        return this.toMessage;
    }

    public void setToMessage(String toMessage) {
        this.toMessage = toMessage;
    }

    public FinancialInstructionType getFinancialInstructionType() {
        return this.financialInstructionType;
    }

    public void setFinancialInstructionType(FinancialInstructionType financialInstructionType) {
        this.financialInstructionType = financialInstructionType;
    }

    public String getExternalTransactionId() {
        return this.externalTransactionId;
    }

    public void setExternalTransactionId(String externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }
}

