/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_3.getrejectedcustodyaccounttransactions;

import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.validators.IsBankAccount;
import com.ericsson.em.validators.IsBankCode;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_3", name="getrejectedcustodyaccounttransactionsrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_3", name="", propOrder={"bankCode", "accountNumber", "numOfTransactions", "indexOffset", "dateFrom", "dateTo"})
public class GetRejectedCustodyAccountTransactionsRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAXLIMIT = 50;
    @IsBankCode
    @XmlElement(name="bankcode", required=false)
    private String bankCode;
    @NotNull
    @IsBankAccount
    @XmlElement(name="accountnumber", required=true)
    private String accountNumber;
    @XmlElement(name="numoftransactions", defaultValue="50")
    @Min(value=1L)
    @NotNull
    private @Min(value=1L) @NotNull int numOfTransactions;
    @XmlElement(name="indexoffset", defaultValue="0")
    private int indexOffset = 0;
    @XmlElement(name="datefrom")
    private Date dateFrom;
    @XmlElement(name="dateto")
    private Date dateTo;

    public GetRejectedCustodyAccountTransactionsRequest() {
        this.numOfTransactions = 50;
    }

    public GetRejectedCustodyAccountTransactionsRequest(String bankCode, String accountNumber) {
        this.bankCode = bankCode;
        this.accountNumber = accountNumber;
        this.numOfTransactions = 50;
    }

    public GetRejectedCustodyAccountTransactionsRequest(String bankCode, String accountNumber, int maxLimit) {
        this.bankCode = bankCode;
        this.accountNumber = accountNumber;
        this.numOfTransactions = maxLimit;
    }

    public GetRejectedCustodyAccountTransactionsRequest(String bankCode, String accountNumber, DateTime dateFrom, DateTime dateTo, int maxLimit, int indexOffset) {
        this.bankCode = bankCode;
        this.accountNumber = accountNumber;
        this.dateFrom = DateHelper.toDate(dateFrom);
        this.dateTo = DateHelper.toDate(dateTo);
        this.numOfTransactions = maxLimit;
        this.indexOffset = indexOffset;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public DateTime getDateFrom() {
        return DateHelper.fromDate(this.dateFrom);
    }

    public void setDateFrom(DateTime dateFrom) {
        this.dateFrom = DateHelper.toDate(dateFrom);
    }

    public DateTime getDateTo() {
        return DateHelper.fromDate(this.dateTo);
    }

    public void setDateTo(DateTime dateTo) {
        this.dateTo = DateHelper.toDate(dateTo);
    }

    public int getIndexOffset() {
        return this.indexOffset;
    }

    public void setIndexOffset(int indexOffset) {
        this.indexOffset = indexOffset;
    }

    public void setNumOfTransactions(int numOfTransactions) {
        this.numOfTransactions = numOfTransactions;
    }

    @XmlTransient
    public int getNumOfTransactions() {
        return this.numOfTransactions;
    }
}

