/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_3.debit;

import com.ericsson.em.m3if.financial.v1_0.prereservation.PreReserveRequest;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.ClientReferenceIdValue;
import com.ericsson.em.m3if.v1_0.common.Coupon;
import com.ericsson.em.m3if.v1_0.common.ExternalTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601Date;
import com.ericsson.em.m3if.v1_0.common.MessageValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.NumberOfRetriesValue;
import com.ericsson.em.m3if.v1_0.common.PreApprovalIdValue;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.ReceiverIdentity;
import com.ericsson.em.m3if.v1_0.common.ReferenceIdValue;
import com.ericsson.em.m3if.v1_1.common.UrlValue;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="debitrequest", namespace="http://www.ericsson.com/em/emm/financial/v1_3")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_3", name="", propOrder={"fromFRI", "toFRI", "preApprovalId", "externalPreApprovalId", "amount", "transferType", "externalTransactionId", "fromMessage", "toMessage", "referenceId", "quoteId", "coupon", "includeOffNet", "callbackUrl", "preReservationValidityDays", "preReservationMessageToPayer", "preReservationId", "scheduleDate", "numberOfRetries", "receiverIdentity"})
@SignedElements(value={"fromfri", "tofri", "preapprovalid", "externalpreapprovalid", "amount/amount", "amount/currency", "externaltransactionid"})
public class DebitRequest
implements Serializable,
QuoteRequest,
PreReserveRequest {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="fromfri")
    private FRIValue fromFRI;
    @Valid
    @XmlElement(name="tofri")
    private FRIValue toFRI;
    @Valid
    @XmlElement(name="preapprovalid", type=PreApprovalIdValue.class)
    private PreApprovalIdValue preApprovalId;
    @Valid
    @XmlElement(name="externalpreapprovalid", type=ReferenceIdValue.class)
    private ReferenceIdValue externalPreApprovalId;
    @NotNull
    @Valid
    @XmlElement(name="amount", required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Valid
    @NotNull
    @XmlElement(name="externaltransactionid", type=ExternalTransactionIdValue.class, required=true)
    private ExternalTransactionIdValue externalTransactionId;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="frommessage")
    private String fromMessage;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="tomessage")
    private String toMessage;
    @Valid
    @XmlElement(name="referenceid")
    private ClientReferenceIdValue referenceId;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="coupon", type=Coupon.class)
    private Coupon coupon;
    @XmlElement(name="includeoffnet", defaultValue="false")
    private Boolean includeOffNet = false;
    @Valid
    @XmlElement(name="callbackurl", type=UrlValue.class)
    private UrlValue callbackUrl;
    @Min(value=0L)
    @XmlElement(name="validitydays")
    private @Min(value=0L) Long preReservationValidityDays;
    @Valid
    @XmlElement(name="reservationmessage")
    private MessageValue preReservationMessageToPayer;
    @IsPositiveLong
    @XmlElement(name="prereservationid")
    private Long preReservationId;
    @Valid
    @XmlElement(name="transfertype", type=TransferType.class)
    private TransferType transferType;
    @Valid
    @XmlElement(name="scheduledate", type=Iso8601Date.class)
    private Iso8601Date scheduleDate;
    @Valid
    @XmlElement(name="numberofretries", type=NumberOfRetriesValue.class)
    private NumberOfRetriesValue numberOfRetries;
    @Valid
    @XmlElement(name="receiveridentity", type=ReceiverIdentity.class, required=false)
    private ReceiverIdentity receiverIdentity;

    @Override
    public FRIValue getFromFRI() {
        return this.fromFRI;
    }

    @Override
    public void setFromFRI(FRIValue fromFRI) {
        this.fromFRI = fromFRI;
    }

    @Override
    public FRIValue getToFRI() {
        return this.toFRI;
    }

    @Override
    public void setToFRI(FRIValue toFRI) {
        this.toFRI = toFRI;
    }

    public Optional<PreApprovalIdValue> getPreApprovalId() {
        return Optional.ofNullable(this.preApprovalId);
    }

    public void setPreApprovalId(PreApprovalIdValue preApprovalId) {
        this.preApprovalId = preApprovalId;
    }

    public Optional<ReferenceIdValue> getExternalPreApprovalId() {
        return Optional.ofNullable(this.externalPreApprovalId);
    }

    public void setExternalPreApprovalId(ReferenceIdValue externalPreApprovalId) {
        this.externalPreApprovalId = externalPreApprovalId;
    }

    @Override
    public MoneyDetails getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    @Override
    public Optional<ExternalTransactionIdValue> getExternalTransactionId() {
        return Optional.of(this.externalTransactionId);
    }

    @Override
    public void setExternalTransactionId(ExternalTransactionIdValue externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public Optional<String> getFromMessage() {
        return Optional.ofNullable(this.fromMessage);
    }

    public void setFromMessage(@Nullable String fromMessage) {
        this.fromMessage = fromMessage;
    }

    public Optional<String> getToMessage() {
        return Optional.ofNullable(this.toMessage);
    }

    public void setToMessage(@Nullable String toMessage) {
        this.toMessage = toMessage;
    }

    @Override
    public Optional<ClientReferenceIdValue> getReferenceId() {
        return Optional.ofNullable(this.referenceId);
    }

    @Override
    public void setReferenceId(@Nullable ClientReferenceIdValue id) {
        this.referenceId = id;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    public Optional<String> getIdOfQuote() {
        return Optional.ofNullable(this.quoteId).map(QuoteId::getValue);
    }

    @Override
    public void setQuoteId(@Nullable QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public Optional<Coupon> getCoupon() {
        return Optional.ofNullable(this.coupon);
    }

    public void setCoupon(@Nullable Coupon coupon) {
        this.coupon = coupon;
    }

    public Optional<Boolean> getIncludeOffNet() {
        return Optional.ofNullable(this.includeOffNet);
    }

    public void setIncludeOffNet(@Nullable Boolean includeOffNet) {
        this.includeOffNet = includeOffNet;
    }

    public Optional<UrlValue> getCallbackUrl() {
        return Optional.ofNullable(this.callbackUrl);
    }

    public void setCallbackUrl(@Nullable UrlValue callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Override
    public Optional<Long> getPreReservationValidityDays() {
        return Optional.ofNullable(this.preReservationValidityDays);
    }

    @Override
    public void setPreReservationValidityDays(@Nullable Long preReservationValidityDays) {
        this.preReservationValidityDays = preReservationValidityDays;
    }

    @Override
    public Optional<MessageValue> getPreReservationMessageToPayer() {
        return Optional.ofNullable(this.preReservationMessageToPayer);
    }

    @Override
    public void setPreReservationMessageToPayer(@Nullable MessageValue preReservationMessageToPayer) {
        this.preReservationMessageToPayer = preReservationMessageToPayer;
    }

    @Override
    public Optional<Long> getPreReservationId() {
        return Optional.ofNullable(this.preReservationId);
    }

    @Override
    public void setPreReservationId(@Nullable Long preReservationId) {
        this.preReservationId = preReservationId;
    }

    @Override
    public Optional<TransferType> getTransferType() {
        return Optional.ofNullable(this.transferType);
    }

    @Override
    public void setTransferType(@Nullable TransferType transferType) {
        this.transferType = transferType;
    }

    public Optional<Iso8601Date> getScheduleDate() {
        return Optional.ofNullable(this.scheduleDate);
    }

    public void setScheduleDate(@Nullable Iso8601Date scheduleDate) {
        this.scheduleDate = scheduleDate;
    }

    public Optional<NumberOfRetriesValue> getNumberOfRetries() {
        return Optional.ofNullable(this.numberOfRetries);
    }

    public void setNumberOfRetries(@Nullable NumberOfRetriesValue numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
    }

    public ReceiverIdentity getReceiverIdentity() {
        return this.receiverIdentity;
    }

    public void setReceiverIdentity(ReceiverIdentity receiverIdentity) {
        this.receiverIdentity = receiverIdentity;
    }
}

