/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_2.debit;

import com.ericsson.em.m3if.financial.v1_0.prereservation.PreReserveRequest;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.ClientReferenceIdValue;
import com.ericsson.em.m3if.v1_0.common.Coupon;
import com.ericsson.em.m3if.v1_0.common.ExternalTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MessageValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.UrlValue;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(name="debitrequest", namespace="http://www.ericsson.com/em/emm/financial/v1_2")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_2", name="", propOrder={"fromFRI", "toFRI", "amount", "transferType", "externalTransactionId", "fromMessage", "toMessage", "referenceId", "quoteId", "coupon", "includeOffNet", "callbackUrl", "preReservationValidityDays", "preReservationMessageToPayer", "preReservationId"})
@SignedElements(value={"fromfri", "tofri", "amount/amount", "amount/currency", "externaltransactionid"})
public class DebitRequest
implements Serializable,
QuoteRequest,
PreReserveRequest {
    private static final long serialVersionUID = 1L;
    @NotNull
    @Valid
    @XmlElement(name="fromfri", required=true)
    private FRIValue fromFRI;
    @NotNull
    @Valid
    @XmlElement(name="tofri", required=true)
    private FRIValue toFRI;
    @NotNull
    @Valid
    @XmlElement(name="amount", required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Valid
    @NotNull
    @XmlElement(name="externaltransactionid", type=ExternalTransactionIdValue.class, required=true)
    private ExternalTransactionIdValue externalTransactionId;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="frommessage")
    private String fromMessage;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="tomessage")
    private String toMessage;
    @Valid
    @XmlElement(name="referenceid")
    private ClientReferenceIdValue referenceId;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="coupon", type=Coupon.class)
    private Coupon coupon;
    @XmlElement(name="includeoffnet", defaultValue="false")
    private Boolean includeOffNet = false;
    @Valid
    @XmlElement(name="callbackurl", type=UrlValue.class)
    private UrlValue callbackUrl;
    @Min(value=0L)
    @XmlElement(name="validitydays")
    private @Min(value=0L) Long preReservationValidityDays;
    @Valid
    @XmlElement(name="reservationmessage")
    private MessageValue preReservationMessageToPayer;
    @IsPositiveLong
    @XmlElement(name="prereservationid")
    private Long preReservationId;
    @Valid
    @XmlElement(name="transfertype", type=TransferType.class)
    private TransferType transferType;

    @Override
    public FRIValue getFromFRI() {
        return this.fromFRI;
    }

    @Override
    public void setFromFRI(FRIValue fromFRI) {
        this.fromFRI = fromFRI;
    }

    @Override
    public FRIValue getToFRI() {
        return this.toFRI;
    }

    @Override
    public void setToFRI(FRIValue toFRI) {
        this.toFRI = toFRI;
    }

    @Override
    public MoneyDetails getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    @Override
    public Optional<ExternalTransactionIdValue> getExternalTransactionId() {
        return Optional.of(this.externalTransactionId);
    }

    @Override
    public void setExternalTransactionId(ExternalTransactionIdValue externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public Optional<String> getFromMessage() {
        return Optional.ofNullable(this.fromMessage);
    }

    public void setFromMessage(@Nullable String fromMessage) {
        this.fromMessage = fromMessage;
    }

    public Optional<String> getToMessage() {
        return Optional.ofNullable(this.toMessage);
    }

    public void setToMessage(@Nullable String toMessage) {
        this.toMessage = toMessage;
    }

    @Override
    public Optional<ClientReferenceIdValue> getReferenceId() {
        return Optional.ofNullable(this.referenceId);
    }

    @Override
    public void setReferenceId(@Nullable ClientReferenceIdValue id) {
        this.referenceId = id;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    public Optional<String> getIdOfQuote() {
        return Optional.ofNullable(this.quoteId).map(QuoteId::getValue);
    }

    @Override
    public void setQuoteId(@Nullable QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public Optional<Coupon> getCoupon() {
        return Optional.ofNullable(this.coupon);
    }

    public void setCoupon(@Nullable Coupon coupon) {
        this.coupon = coupon;
    }

    public Optional<Boolean> getIncludeOffNet() {
        return Optional.ofNullable(this.includeOffNet);
    }

    public void setIncludeOffNet(@Nullable Boolean includeOffNet) {
        this.includeOffNet = includeOffNet;
    }

    public Optional<UrlValue> getCallbackUrl() {
        return Optional.ofNullable(this.callbackUrl);
    }

    public void setCallbackUrl(@Nullable UrlValue callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Override
    public Optional<Long> getPreReservationValidityDays() {
        return Optional.ofNullable(this.preReservationValidityDays);
    }

    @Override
    public void setPreReservationValidityDays(@Nullable Long preReservationValidityDays) {
        this.preReservationValidityDays = preReservationValidityDays;
    }

    @Override
    public Optional<MessageValue> getPreReservationMessageToPayer() {
        return Optional.ofNullable(this.preReservationMessageToPayer);
    }

    @Override
    public void setPreReservationMessageToPayer(@Nullable MessageValue preReservationMessageToPayer) {
        this.preReservationMessageToPayer = preReservationMessageToPayer;
    }

    @Override
    public Optional<Long> getPreReservationId() {
        return Optional.ofNullable(this.preReservationId);
    }

    @Override
    public void setPreReservationId(@Nullable Long preReservationId) {
        this.preReservationId = preReservationId;
    }

    @Override
    public Optional<TransferType> getTransferType() {
        return Optional.ofNullable(this.transferType);
    }

    @Override
    public void setTransferType(@Nullable TransferType transferType) {
        this.transferType = transferType;
    }
}

