/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_2.common;

import com.ericsson.em.m3if.financial.v1_0.common.Direction;
import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionStatus;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v2_0.common.TransferType;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsFilesystemPath;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsNumericString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsUsername;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_2/common", name="getcustodyaccounttransactionhistoryentrytype", propOrder={"financialTransactionId", "transactionStatus", "transferType", "startDate", "commitDate", "initiatingUser", "realUser", "initiatingAccountHolder", "realAccountHolder", "direction", "from", "fromAccount", "fromAmount", "fromNote", "fromAccountHolder", "originalAmount", "to", "toAccount", "toAmount", "toMessage", "mainInstructionId", "instructionId", "externalTransactionId", "toAccountHolder", "settlementFileName", "bankTransactionId", "bankTransactionType"})
public class GetCustodyAccountTransactionHistoryEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsNumericString
    @XmlElement(name="financialtransactionid")
    private String financialTransactionId = null;
    @XmlElement(name="transactionstatus")
    private FinancialTransactionStatus transactionStatus;
    @XmlElement(name="transfertype")
    private TransferType transferType;
    @XmlElement(name="startdate")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date startDate;
    @XmlElement(name="commitdate")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date commitDate;
    @IsUsername
    @XmlElement(name="initiatinguser")
    private String initiatingUser;
    @IsUsername
    @XmlElement(name="realuser")
    private String realUser;
    @IsIdentity
    @XmlElement(name="initiatingaccountholder")
    private String initiatingAccountHolder;
    @IsIdentity
    @XmlElement(name="realaccountholder")
    private String realAccountHolder;
    @XmlElement(name="direction")
    private Direction direction;
    @IsFinancialResourceIdentifier
    @XmlElement(name="from")
    private String from;
    @IsFinancialResourceIdentifier
    @XmlElement(name="fromaccount")
    private String fromAccount;
    @Valid
    @XmlElement(name="fromamount")
    @IsPositiveAmount
    private MoneyDetails fromAmount;
    @IsRestrictedString
    @XmlElement(name="fromnote")
    private String fromNote;
    @IsIdentity
    @XmlElement(name="fromaccountholder")
    private String fromAccountHolder;
    @Valid
    @XmlElement(name="originalamount")
    @IsPositiveAmount
    private MoneyDetails originalAmount;
    @IsFinancialResourceIdentifier
    @XmlElement(name="to")
    private String to;
    @IsFinancialResourceIdentifier
    @XmlElement(name="toaccount")
    private String toAccount;
    @Valid
    @XmlElement(name="toamount")
    @IsPositiveAmount
    private MoneyDetails toAmount;
    @IsRestrictedString
    @XmlElement(name="tomessage")
    private String toMessage;
    @XmlElement(name="instructionid")
    private Long instructionId;
    @XmlElement(name="maininstructionid")
    private Long mainInstructionId;
    @IsExternalTransactionIdString
    @XmlElement(name="externaltransactionid")
    private String externalTransactionId;
    @IsIdentity
    @XmlElement(name="toaccountholder")
    private String toAccountHolder;
    @IsFilesystemPath
    @XmlElement(name="settlementfilename")
    private String settlementFileName;
    @IsExternalTransactionIdString
    @XmlElement(name="banktransactionid")
    private String bankTransactionId;
    @XmlElement(name="banktransactiontype")
    private TransferType bankTransactionType;

    public String getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(String financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public FinancialTransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(FinancialTransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public DateTime getStartDate() {
        return DateHelper.fromDate(this.startDate);
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = DateHelper.toDate(startDate);
    }

    public MoneyDetails getFromAmount() {
        return this.fromAmount;
    }

    public void setFromAmount(MoneyDetails fromAmount) {
        this.fromAmount = fromAmount;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String source) {
        this.from = source;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String target) {
        this.to = target;
    }

    public String getFromNote() {
        return this.fromNote;
    }

    public void setFromNote(String fromNote) {
        this.fromNote = fromNote;
    }

    public void setToAmount(MoneyDetails targetAmount) {
        this.toAmount = targetAmount;
    }

    public MoneyDetails getToAmount() {
        return this.toAmount;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public String getToMessage() {
        return this.toMessage;
    }

    public void setToMessage(String receiverMessage) {
        this.toMessage = receiverMessage;
    }

    public String getFromAccount() {
        return this.fromAccount;
    }

    public void setFromAccount(String fromAccount) {
        this.fromAccount = fromAccount;
    }

    public String getToAccount() {
        return this.toAccount;
    }

    public void setToAccount(String toAccount) {
        this.toAccount = toAccount;
    }

    public String getInitiatingUser() {
        return this.initiatingUser;
    }

    public void setInitiatingUser(String initiatingUser) {
        this.initiatingUser = initiatingUser;
    }

    public String getRealUser() {
        return this.realUser;
    }

    public void setRealUser(String real) {
        this.realUser = real;
    }

    public String getInitiatingAccountHolder() {
        return this.initiatingAccountHolder;
    }

    public void setInitiatingAccountHolder(String initiatingAccountHolder) {
        this.initiatingAccountHolder = initiatingAccountHolder;
    }

    public String getRealAccountHolder() {
        return this.realAccountHolder;
    }

    public void setRealAccountHolder(String realAccountHolder) {
        this.realAccountHolder = realAccountHolder;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public DateTime getCommitDate() {
        return DateHelper.fromDate(this.commitDate);
    }

    public void setCommitDate(DateTime commitDate) {
        this.commitDate = DateHelper.toDate(commitDate);
    }

    public Long getMainInstructionId() {
        return this.mainInstructionId;
    }

    public void setMainInstructionId(Long mainInstructionId) {
        this.mainInstructionId = mainInstructionId;
    }

    public Long getInstructionId() {
        return this.instructionId;
    }

    public void setInstructionId(Long instructionId) {
        this.instructionId = instructionId;
    }

    public String getExternalTransactionId() {
        return this.externalTransactionId;
    }

    public void setExternalTransactionId(String externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public String getFromAccountHolder() {
        return this.fromAccountHolder;
    }

    public void setFromAccountHolder(String fromAccountHolder) {
        this.fromAccountHolder = fromAccountHolder;
    }

    public String getToAccountHolder() {
        return this.toAccountHolder;
    }

    public void setToAccountHolder(String toAccountHolder) {
        this.toAccountHolder = toAccountHolder;
    }

    public MoneyDetails getOriginalAmount() {
        return this.originalAmount;
    }

    public void setOriginalAmount(MoneyDetails originalAmount) {
        this.originalAmount = originalAmount;
    }

    public void setSettlementFileName(String settlementFileName) {
        this.settlementFileName = settlementFileName;
    }

    public String getSettlementFileName() {
        return this.settlementFileName;
    }

    public String getBankTransactionId() {
        return this.bankTransactionId;
    }

    public void setBankTransactionId(String bankTransactionId) {
        this.bankTransactionId = bankTransactionId;
    }

    public void setBankTransactionType(TransferType bankTransactionType) {
        this.bankTransactionType = bankTransactionType;
    }

    public TransferType getBankTransactionType() {
        return this.bankTransactionType;
    }
}

