/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_1.transfertoanybankaccount;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.approvals.ExpiredApprovalAware;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsBankCode;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsNumericString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_1", name="transfertoanybankaccountrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_1", name="", propOrder={"amount", "sendingFRI", "receivingAccountNumber", "receivingClearingNumber", "senderNote", "receiverMessage", "quoteId"})
public class TransferToAnyBankAccountRequest
implements Serializable,
QuoteRequest,
ExpiredApprovalAware {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.1";
    @NotNull
    @Valid
    @XmlElement(name="amount", required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="sendingfri", required=true)
    private String sendingFRI;
    @NotBlank
    @Length(max=64)
    @IsNumericString
    @XmlElement(name="receivingaccountnumber", required=true)
    private String receivingAccountNumber;
    @IsBankCode
    @XmlElement(name="receivingclearingnumber")
    private String receivingClearingNumber;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="sendernote", required=false)
    private String senderNote;
    @Length(max=100)
    @IsRestrictedString
    @XmlElement(name="receivermessage", required=false)
    private String receiverMessage;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;

    public TransferToAnyBankAccountRequest() {
    }

    public TransferToAnyBankAccountRequest(MoneyDetails amount, String sendingFRI, String receivingAccountNumber, String receivingClearingNumber) {
        this.amount = amount;
        this.sendingFRI = sendingFRI;
        this.receivingAccountNumber = receivingAccountNumber;
        this.receivingClearingNumber = receivingClearingNumber;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(String sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public String getReceivingAccountNumber() {
        return this.receivingAccountNumber;
    }

    public void setReceivingAccountNumber(String receivingAccountNumber) {
        this.receivingAccountNumber = receivingAccountNumber;
    }

    public String getReceivingClearingNumber() {
        return this.receivingClearingNumber;
    }

    public void setReceivingClearingNumber(String receivingClearingNumber) {
        this.receivingClearingNumber = receivingClearingNumber;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    @Override
    public Optional<String> getSendingFri() {
        return Optional.of(this.sendingFRI);
    }

    @Override
    public Optional<String> getReceivingFri() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getSupplementaryData() {
        return Optional.of("Receiving account number: " + this.receivingAccountNumber);
    }
}

