/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.transferfrombankaccount;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.approvals.ExpiredApprovalAware;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="transferfrombankaccountrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="", propOrder={"sendingIdentity", "receivingFRI", "amount", "receiverMessage", "bankAccountMessage", "quoteId"})
public class TransferFromBankAccountRequest
implements Serializable,
QuoteRequest,
ExpiredApprovalAware {
    private static final long serialVersionUID = 1L;
    @IsIdentity
    @XmlElement(name="sendingidentity", required=false)
    private String sendingIdentity;
    @IsFinancialResourceIdentifier
    @NotNull
    @XmlElement(name="receivingfri", required=true)
    private String receivingFRI;
    @NotNull
    @Valid
    @XmlElement(name="amount", required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="receivermessage", required=false)
    private String receiverMessage;
    @Length(max=100)
    @IsRestrictedString
    @XmlElement(name="bankaccountmessage", required=false)
    private String bankAccountMessage;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;

    public TransferFromBankAccountRequest() {
    }

    public TransferFromBankAccountRequest(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getSendingIdentity() {
        return this.sendingIdentity;
    }

    public void setSendingIdentity(String sendingIdentity) {
        this.sendingIdentity = sendingIdentity;
    }

    public String getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(String receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public String getBankAccountMessage() {
        return this.bankAccountMessage;
    }

    public void setBankAccountMessage(String bankAccountMessage) {
        this.bankAccountMessage = bankAccountMessage;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    @Override
    public Optional<String> getSendingFri() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getReceivingFri() {
        return Optional.of(this.receivingFRI);
    }

    @Override
    public Optional<String> getSupplementaryData() {
        return Optional.ofNullable(this.sendingIdentity == null ? null : "Sending identity: " + this.sendingIdentity);
    }
}

