/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.getmerchantcashhistory;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionStatus;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v2_1.common.FinancialInstructionType;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsPositiveLong;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="getmerchantcashhistoryrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="", propOrder={"fri", "numOfTransactions", "indexOffset", "financialTransactionId", "transactionStatus", "transactionType", "startDateFrom", "startDateTo", "otherFri", "cashAccountHolderIdentity", "quoteId"})
public class GetMerchantCashHistoryRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private static final int DEFAULT_MAXLIMIT = 50;
    @IsFinancialResourceIdentifier
    @XmlElement(name="fri")
    private String fri;
    @Min(value=1L)
    @Max(value=50L)
    @NotNull
    @XmlElement(name="numoftransactions", defaultValue="50")
    private @Min(value=1L) @Max(value=50L) @NotNull Integer numOfTransactions = 50;
    @Min(value=0L)
    @XmlElement(name="indexoffset", defaultValue="0")
    private @Min(value=0L) Integer indexOffset = 0;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="financialtransactionid")
    private Long financialTransactionId;
    @XmlElement(name="transactionstatus")
    private FinancialTransactionStatus transactionStatus;
    @Valid
    @XmlElement(name="transactiontype", type=FinancialInstructionType.class)
    private FinancialInstructionType transactionType;
    @Valid
    @IsDateTimeValue
    @XmlElement(name="startdatefrom")
    private DateTimeValue startDateFrom;
    @Valid
    @IsDateTimeValue
    @XmlElement(name="startdateto")
    private DateTimeValue startDateTo;
    @IsFinancialResourceIdentifier
    @XmlElement(name="otherfri")
    private String otherFri;
    @IsIdentity
    @XmlElement(name="cashuseridentity")
    private String cashAccountHolderIdentity;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;

    public GetMerchantCashHistoryRequest() {
        this(null, null, null, 50, 0);
    }

    public GetMerchantCashHistoryRequest(String fri) {
        this(fri, 50);
    }

    public GetMerchantCashHistoryRequest(String fri, int maxLimit) {
        this(fri, null, null, maxLimit, 0);
    }

    public GetMerchantCashHistoryRequest(String fri, DateTimeValue dateFrom, DateTimeValue dateTo, int maxLimit, int indexOffset) {
        this.startDateFrom = dateFrom;
        this.startDateTo = dateTo;
        this.fri = fri;
        this.numOfTransactions = maxLimit;
        this.indexOffset = indexOffset;
    }

    public String getFri() {
        return this.fri;
    }

    public void setFri(String fri) {
        this.fri = fri;
    }

    public DateTime getStartDateFrom() {
        return this.startDateFrom != null ? this.startDateFrom.getTimestampAsDate() : null;
    }

    public void setStartDateFrom(DateTime startDateFrom) {
        this.startDateFrom = startDateFrom != null ? new DateTimeValue(startDateFrom) : null;
    }

    public DateTime getStartDateTo() {
        return this.startDateTo != null ? this.startDateTo.getTimestampAsDate() : null;
    }

    public void setStartDateTo(DateTime startDateTo) {
        this.startDateTo = startDateTo != null ? new DateTimeValue(startDateTo) : null;
    }

    public int getIndexOffset() {
        return this.indexOffset;
    }

    public void setIndexOffset(int indexOffset) {
        this.indexOffset = indexOffset;
    }

    public void setNumOfTransactions(int numOfTransactions) {
        this.numOfTransactions = numOfTransactions;
    }

    @XmlTransient
    public int getNumOfTransactions() {
        return this.numOfTransactions;
    }

    public Long getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(Long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public FinancialTransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(FinancialTransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public FinancialInstructionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(FinancialInstructionType transactionType) {
        this.transactionType = transactionType;
    }

    public String getOtherFri() {
        return this.otherFri;
    }

    public void setOtherFri(String otherFri) {
        this.otherFri = otherFri;
    }

    public String getCashAccountHolderIdentity() {
        return this.cashAccountHolderIdentity;
    }

    public void setCashAccountHolderIdentity(String cashAccountHolderIdentity) {
        this.cashAccountHolderIdentity = cashAccountHolderIdentity;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }
}

