/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.common;

import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionId;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionStatus;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0/common", name="financialreceipt", propOrder={"financialTransactionId", "transferType", "transactionStatus", "startDate", "commitDate", "amount", "fee", "loyFee", "vat", "discount", "promotion", "loyReward"})
public class FinancialReceipt
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="financialtransactionid", type=FinancialTransactionId.class, required=true)
    private FinancialTransactionId financialTransactionId;
    @Valid
    @NotNull
    @XmlElement(name="transfertype", required=true)
    private TransferType transferType;
    @NotNull
    @XmlElement(name="transactionstatus", required=true)
    private FinancialTransactionStatus transactionStatus;
    @NotNull
    @Valid
    @IsDateTimeValue
    @XmlElement(name="startdate", required=true)
    private DateTimeValue startDate;
    @Valid
    @IsDateTimeValue
    @XmlElement(name="commitdate")
    private DateTimeValue commitDate;
    @Valid
    @XmlElement(name="amount")
    @IsPositiveAmount
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="fee")
    @IsPositiveAmount
    private MoneyDetails fee;
    @XmlElement(name="loyfee")
    private BigDecimal loyFee;
    @Deprecated
    @Valid
    @XmlElement(name="vat")
    @IsPositiveAmount
    private MoneyDetails vat;
    @Valid
    @XmlElement(name="discount")
    @IsPositiveAmount
    private MoneyDetails discount;
    @Valid
    @XmlElement(name="promotion")
    @IsPositiveAmount
    private MoneyDetails promotion;
    @XmlElement(name="loyreward")
    private BigDecimal loyReward;

    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public DateTime getStartDate() {
        return this.startDate.getTimestampAsDate();
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = new DateTimeValue(startDate);
    }

    public DateTime getCommitDate() {
        return this.commitDate.getTimestampAsDate();
    }

    public void setCommitDate(DateTime commitDate) {
        this.commitDate = new DateTimeValue(commitDate);
    }

    public MoneyDetails getFee() {
        return this.fee;
    }

    public void setFee(MoneyDetails fee) {
        this.fee = fee;
    }

    public MoneyDetails getDiscount() {
        return this.discount;
    }

    public void setDiscount(MoneyDetails discount) {
        this.discount = discount;
    }

    public MoneyDetails getPromotion() {
        return this.promotion;
    }

    public void setPromotion(MoneyDetails promotion) {
        this.promotion = promotion;
    }

    public BigDecimal getLoyFee() {
        return this.loyFee;
    }

    public void setLoyFee(BigDecimal loyFee) {
        this.loyFee = loyFee;
    }

    public BigDecimal getLoyReward() {
        return this.loyReward;
    }

    public void setLoyReward(BigDecimal loyReward) {
        this.loyReward = loyReward;
    }

    @Deprecated
    public MoneyDetails getVat() {
        return this.vat;
    }

    @Deprecated
    public void setVat(MoneyDetails vat) {
        this.vat = vat;
    }

    public FinancialTransactionId getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(FinancialTransactionId financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public FinancialTransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(FinancialTransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }
}

