/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.externalauthorization.v1_0.common;

import com.ericsson.em.m3if.externalauthorization.v1_0.common.AccountHolderInformation;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionId;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import com.ericsson.em.validators.IsNumericString;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/externalauthorization/v1_0/common", name="financialtransactions")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/externalauthorization/v1_0/common", name="", propOrder={"sessionId", "financialTransactionId", "quoteId", "transferType", "amount", "assisting", "sender", "receiver", "sendingAccountOwner", "receivingAccountOwner"})
public class FinancialTransaction
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @IsNumericString
    @XmlElement(name="sessionid", type=String.class)
    private String sessionId;
    @Valid
    @XmlElement(name="financialtransactionid", type=FinancialTransactionId.class)
    private FinancialTransactionId financialTransactionId;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class)
    private QuoteId quoteId;
    @Valid
    @NotNull
    @XmlElement(name="transfertype", type=TransferType.class, required=true)
    private TransferType transferType;
    @Valid
    @NotNull
    @IsPositiveAmount
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="assisting", type=AccountHolderInformation.class)
    private AccountHolderInformation assisting;
    @Valid
    @XmlElement(name="sender", type=AccountHolderInformation.class)
    private AccountHolderInformation sender;
    @Valid
    @XmlElement(name="receiver", type=AccountHolderInformation.class)
    private AccountHolderInformation receiver;
    @Valid
    @XmlElement(name="sendingaccountowner", type=AccountHolderInformation.class)
    private AccountHolderInformation sendingAccountOwner;
    @Valid
    @XmlElement(name="receivingaccountowner", type=AccountHolderInformation.class)
    private AccountHolderInformation receivingAccountOwner;

    protected FinancialTransaction() {
    }

    private FinancialTransaction(Builder builder) {
        this.sessionId = builder.sessionId;
        this.financialTransactionId = builder.financialTransactionId;
        this.quoteId = builder.quoteId;
        this.transferType = builder.transferType;
        this.amount = builder.amount;
        this.assisting = builder.assisting;
        this.sender = builder.sender;
        this.receiver = builder.receiver;
        this.sendingAccountOwner = builder.sendingAccountOwner;
        this.receivingAccountOwner = builder.receivingAccountOwner;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setFinancialTransactionId(FinancialTransactionId financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public FinancialTransactionId getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public AccountHolderInformation getAssisting() {
        return this.assisting;
    }

    public void setAssisting(AccountHolderInformation assisting) {
        this.assisting = assisting;
    }

    public AccountHolderInformation getSender() {
        return this.sender;
    }

    public void setSender(AccountHolderInformation sender) {
        this.sender = sender;
    }

    public AccountHolderInformation getReceiver() {
        return this.receiver;
    }

    public void setReceiver(AccountHolderInformation receiver) {
        this.receiver = receiver;
    }

    public AccountHolderInformation getSendingAccountOwner() {
        return this.sendingAccountOwner;
    }

    public void setSendingAccountOwner(AccountHolderInformation sendingAccountOwner) {
        this.sendingAccountOwner = sendingAccountOwner;
    }

    public AccountHolderInformation getReceivingAccountOwner() {
        return this.receivingAccountOwner;
    }

    public void setReceivingAccountOwner(AccountHolderInformation receivingAccountOwner) {
        this.receivingAccountOwner = receivingAccountOwner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinancialTransaction request = (FinancialTransaction)o;
        return Objects.equals(this.sessionId, request.sessionId) && Objects.equals(this.quoteId, request.quoteId) && Objects.equals(this.transferType, request.transferType) && Objects.equals(this.amount, request.amount) && Objects.equals(this.assisting, request.assisting) && Objects.equals(this.sender, request.sender) && Objects.equals(this.receiver, request.receiver) && Objects.equals(this.sendingAccountOwner, request.sendingAccountOwner) && Objects.equals(this.receivingAccountOwner, request.receivingAccountOwner);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.quoteId, this.transferType, this.amount, this.assisting, this.sender, this.receiver, this.sendingAccountOwner, this.receivingAccountOwner);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String sessionId;
        private FinancialTransactionId financialTransactionId;
        private QuoteId quoteId;
        private TransferType transferType;
        private MoneyDetails amount;
        private AccountHolderInformation assisting;
        private AccountHolderInformation sender;
        private AccountHolderInformation receiver;
        private AccountHolderInformation sendingAccountOwner;
        private AccountHolderInformation receivingAccountOwner;

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder financialTransactionId(FinancialTransactionId financialTransactionId) {
            this.financialTransactionId = financialTransactionId;
            return this;
        }

        public Builder quoteId(QuoteId quoteId) {
            this.quoteId = quoteId;
            return this;
        }

        public Builder transferType(TransferType transferType) {
            this.transferType = transferType;
            return this;
        }

        public Builder amount(MoneyDetails amount) {
            this.amount = amount;
            return this;
        }

        public Builder assisting(AccountHolderInformation assisting) {
            this.assisting = assisting;
            return this;
        }

        public Builder sender(AccountHolderInformation sender) {
            this.sender = sender;
            return this;
        }

        public Builder receiver(AccountHolderInformation receiver) {
            this.receiver = receiver;
            return this;
        }

        public Builder sendingAccountOwner(AccountHolderInformation sendingAccountOwner) {
            this.sendingAccountOwner = sendingAccountOwner;
            return this;
        }

        public Builder receivingAccountOwner(AccountHolderInformation receivingAccountOwner) {
            this.receivingAccountOwner = receivingAccountOwner;
            return this;
        }

        public FinancialTransaction build() {
            return new FinancialTransaction(this);
        }
    }
}

