/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.devicecredential.v1_0.common;

import com.ericsson.em.emm.util.ValueObject;
import com.ericsson.em.validators.IsBase64Encoded;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NotBlank;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.utilities.Base64;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/devicecredential/v1_0/common", name="deviceuserid")
public class DeviceUserIdValue
implements Comparable<DeviceUserIdValue>,
Serializable,
ValueObject {
    private static final long serialVersionUID = 1L;
    @Length(max=256)
    @NotNull
    @NotBlank
    @XmlValue
    @IsBase64Encoded
    private final String value;

    protected DeviceUserIdValue() {
        this.value = null;
    }

    private DeviceUserIdValue(String value) {
        this.value = value;
    }

    public static DeviceUserIdValue fromString(String value) {
        if (value == null) {
            return null;
        }
        return new DeviceUserIdValue(Base64.encode(value.getBytes()));
    }

    @Override
    public String getValueAsString() {
        if (this.value == null) {
            return "";
        }
        try {
            return new String(Base64.decode(this.value));
        }
        catch (IOException e) {
            throw new ValidationException("deviceuserid has the wrong format");
        }
    }

    public static Optional<String> asString(DeviceUserIdValue name) {
        if (name == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(name.getValueAsString());
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceUserIdValue other = (DeviceUserIdValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public int compareTo(DeviceUserIdValue o) {
        return this.value.compareTo(o.value);
    }
}

