/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.card.v1_0.createvirtualcard;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsDateTime;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsRestrictedString;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/card/v1_0", name="createvirtualcardrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/card/v1_0", name="", propOrder={"fri", "template", "amount", "expiry", "quoteId"})
public class CreateVirtualCardRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @IsFinancialResourceIdentifier
    @XmlElement(name="fri")
    private String fri;
    @IsRestrictedString
    @NotNull
    @XmlElement(name="template", required=true)
    private String template;
    @NotNull
    @Valid
    @XmlElement(name="amount", required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @NotNull
    @IsDateTime
    @XmlSchemaType(name="dateTime")
    @XmlElement(name="expiry", required=true)
    private XMLGregorianCalendar expiry;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;

    public String getFri() {
        return this.fri;
    }

    public void setFri(String fri) {
        this.fri = fri;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public DateTime getExpiry() {
        return DateHelper.toDateTime(this.expiry);
    }

    public void setExpiry(DateTime expiry) {
        this.expiry = DateHelper.fromDateTime(expiry);
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }
}

