/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.card.v1_0.backend.updatecarddetails;

import com.ericsson.em.m3if.card.v1_0.common.CardStateType;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.validators.IsCardReferenceNumber;
import com.ericsson.em.validators.IsDateTime;
import com.ericsson.em.validators.IsMaskedCardNumberString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/card/v1_0/backend", name="updatecarddetailsrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/card/v1_0/backend", name="", propOrder={"cardReferenceNumber", "maskedCardNumber", "expiry", "status"})
public class UpdateCardDetailsRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @IsCardReferenceNumber
    @XmlElement(name="cardreferencenumber", required=true)
    private String cardReferenceNumber;
    @NotNull
    @IsMaskedCardNumberString
    @Length(min=8, max=24)
    @XmlElement(name="maskedcardnumber", required=true)
    private String maskedCardNumber;
    @NotNull
    @IsDateTime
    @XmlSchemaType(name="date")
    @XmlElement(name="expiry", required=true)
    private XMLGregorianCalendar expiry;
    @NotNull
    @Valid
    @XmlElement(name="status", required=true)
    private CardStateType status;

    public String getCardReferenceNumber() {
        return this.cardReferenceNumber;
    }

    public void setCardReferenceNumber(String cardReferenceNumber) {
        this.cardReferenceNumber = cardReferenceNumber;
    }

    public String getMaskedCardNumber() {
        return this.maskedCardNumber;
    }

    public void setMaskedCardNumber(String maskedCardNumber) {
        this.maskedCardNumber = maskedCardNumber;
    }

    public DateTime getExpiry() {
        return DateHelper.toDateTime(this.expiry);
    }

    public void setExpiry(DateTime expiry) {
        this.expiry = DateHelper.fromDateTime(expiry);
    }

    public CardStateType getStatus() {
        return this.status;
    }

    public void setStatus(CardStateType status) {
        this.status = status;
    }
}

