/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.campaignmanagement.hidden.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.AmountValue;
import com.ericsson.em.m3if.v1_0.common.ExternalTextValue;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/campaignmanagement/hidden/v1_0/common", name="incentive", propOrder={"incentiveValue", "incentiveValueFixed", "externalProductId"})
public class Incentive
implements Serializable {
    private static final long serialVersionUID = -8710625723292696542L;
    @Valid
    @XmlElement(name="incentivevalue", type=AmountValue.class)
    private AmountValue incentiveValue;
    @Valid
    @XmlElement(name="incentivevaluefixed", defaultValue="true")
    private boolean incentiveValueFixed = Boolean.TRUE;
    @Valid
    @XmlElement(name="externalproductid", type=ExternalTextValue.class)
    private ExternalTextValue externalProductId;

    public AmountValue getIncentiveValue() {
        return this.incentiveValue;
    }

    public void setIncentiveValue(AmountValue incentiveValue) {
        if (this.externalProductId != null) {
            throw new IllegalStateException("Monetary incentive can not be set when external incentive is specified");
        }
        this.incentiveValue = incentiveValue;
    }

    public boolean isIncentiveValueFixed() {
        return this.incentiveValueFixed;
    }

    public void setIncentiveValueFixed(boolean incentiveValueFixed) {
        this.incentiveValueFixed = incentiveValueFixed;
    }

    public ExternalTextValue getExternalProductId() {
        return this.externalProductId;
    }

    public void setExternalProductId(ExternalTextValue externalProductId) {
        if (this.incentiveValue != null) {
            throw new IllegalStateException("External incentive can not be set when monetary incentive is specified");
        }
        this.externalProductId = externalProductId;
    }

    public static Incentive fromLong(long incentiveValue, boolean valueFixed) {
        Incentive incentive = new Incentive();
        incentive.setIncentiveValue(AmountValue.fromLong(incentiveValue));
        incentive.setIncentiveValueFixed(valueFixed);
        return incentive;
    }

    public static Incentive fromBigDecimal(BigDecimal incentiveValue, boolean valueFixed) {
        Incentive incentive = new Incentive();
        incentive.setIncentiveValue(AmountValue.fromBigDecimal(incentiveValue));
        incentive.setIncentiveValueFixed(valueFixed);
        return incentive;
    }

    public static Incentive fromExternalProductId(String productId) {
        Incentive incentive = new Incentive();
        incentive.setExternalProductId(ExternalTextValue.fromString(productId));
        return incentive;
    }

    public String toString() {
        return "Incentive{incentiveValue=" + String.valueOf(this.incentiveValue) + ", incentiveValueFixed=" + this.incentiveValueFixed + ", externalProductId=" + String.valueOf(this.externalProductId) + "}";
    }

    public String toAuditLogString() {
        return "{incentiveValue=" + String.valueOf(this.incentiveValue) + ", incentiveValueFixed=" + this.incentiveValueFixed + ", externalProductId=" + String.valueOf(this.externalProductId) + "}";
    }
}

