/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.billmanager.v1_0.billpayment;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.ReceiverMessageValue;
import com.ericsson.em.m3if.v1_0.common.SenderNoteValue;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/billmanager/v1_0", name="billpaymentrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/billmanager/v1_0", name="", propOrder={"sendingFri", "receivingFri", "customerReference", "billReference", "amount", "senderNote", "receiverMessage", "quoteId"})
public class BillPaymentRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="sendingfri", type=FRIValue.class, required=true)
    private FRIValue sendingFri;
    @Valid
    @NotNull
    @XmlElement(name="receivingfri", type=FRIValue.class, required=true)
    private FRIValue receivingFri;
    @Valid
    @IsExternalReferenceString
    @Length(max=50)
    @XmlElement(name="customerreference")
    private String customerReference;
    @Valid
    @IsExternalReferenceString
    @Length(max=50)
    @XmlElement(name="billreference")
    private String billReference;
    @NotNull
    @Valid
    @IsPositiveAmount
    @XmlElement(name="amount", required=true)
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="sendernote")
    private SenderNoteValue senderNote;
    @Valid
    @XmlElement(name="receivermessage")
    private ReceiverMessageValue receiverMessage;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;

    public FRIValue getSendingFri() {
        return this.sendingFri;
    }

    public void setSendingFri(FRIValue sendingFri) {
        this.sendingFri = sendingFri;
    }

    public FRIValue getReceivingFri() {
        return this.receivingFri;
    }

    public void setReceivingFri(FRIValue receivingFri) {
        this.receivingFri = receivingFri;
    }

    public String getCustomerReference() {
        return this.customerReference;
    }

    public void setCustomerReference(String customerReference) {
        this.customerReference = customerReference;
    }

    public String getBillReference() {
        return this.billReference;
    }

    public void setBillReference(String billReference) {
        this.billReference = billReference;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public SenderNoteValue getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(SenderNoteValue senderNote) {
        this.senderNote = senderNote;
    }

    public ReceiverMessageValue getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(ReceiverMessageValue receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }
}

