/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.batchtransfer.v1_0.common;

import com.ericsson.em.m3if.batchtransfer.v1_0.common.BatchReversalTransactionRecord;
import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.IsNumericString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.IsSingleWordString;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/batchtransfer/v1_0/common", name="transactionrecordtype", propOrder={"transactionIdentifier", "receiverId", "transactionId", "transactionDateTime", "amount", "result", "reason", "message", "fee", "transferedAmount", "batchReversalTransactionRecord"})
public class TransactionRecord
implements Serializable {
    private static final long serialVersionUID = 2919154153446969085L;
    @IsExternalReferenceString
    @XmlElement(name="transactionidentifier", required=true)
    private String transactionIdentifier;
    @IsIdentity
    @XmlElement(name="receiverid", required=true)
    private String receiverId;
    @IsNumericString
    @XmlElement(name="transactionid")
    private String transactionId;
    @XmlElement(name="transactiondatetime")
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date transactionDateTime;
    @Valid
    @NotNull
    @XmlElement(name="amount", required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @IsSingleWordString
    @XmlElement(name="result", required=true)
    private String result;
    @IsMultilineRestrictedString
    @XmlElement(name="reason")
    private String reason;
    @IsRestrictedString
    @XmlElement(name="message")
    private String message;
    @Valid
    @XmlElement(name="fee")
    @IsPositiveAmount
    private MoneyDetails fee;
    @Valid
    @XmlElement(name="transferedamount")
    @IsPositiveAmount
    private MoneyDetails transferedAmount;
    @XmlElement(name="batchreversaltransactionrecord")
    @Valid
    private BatchReversalTransactionRecord batchReversalTransactionRecord;

    public String getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    public void setTransactionIdentifier(String transactionIdentifier) {
        this.transactionIdentifier = transactionIdentifier;
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public DateTime getTransactionDateTime() {
        return this.transactionDateTime == null ? null : new DateTime(this.transactionDateTime);
    }

    public void setTransactionDateTime(DateTime transactionDateTime) {
        this.transactionDateTime = transactionDateTime == null ? null : transactionDateTime.toDate();
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public MoneyDetails getFee() {
        return this.fee;
    }

    public void setFee(MoneyDetails fee) {
        this.fee = fee;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public MoneyDetails getTransferedAmount() {
        return this.transferedAmount;
    }

    public void setTransferedAmount(MoneyDetails transferedAmount) {
        this.transferedAmount = transferedAmount;
    }

    public BatchReversalTransactionRecord getBatchReversalTransactionRecord() {
        return this.batchReversalTransactionRecord;
    }

    public void setBatchReversalTransactionRecord(BatchReversalTransactionRecord batchReversalTransactionRecord) {
        this.batchReversalTransactionRecord = batchReversalTransactionRecord;
    }
}

