/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.custom.view;

import com.ericsson.em.emm.ere.rma.custom.model.CollectionOfMultiFieldsModel;
import com.ericsson.em.emm.ere.rma.custom.view.AbstractCollectionOfMultiFieldEntryVariable;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.PanelVariableEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;

public class CollectionOfMultiFieldsEntryVariable
extends AbstractCollectionOfMultiFieldEntryVariable
implements Observer {
    public static final String ACTION_ENTRY_ADDED = "entryAdded";
    public static final String ACTION_ENTRY_REMOVED = "entryRemoved";
    private String action = "";

    public CollectionOfMultiFieldsEntryVariable(String label, CollectionOfMultiFieldsModel model) {
        super(label, model);
        this.model.addObserver(this);
    }

    @Override
    public Object getValueObject() {
        return this.model;
    }

    @Override
    public CollectionOfMultiFieldsModel getModel() {
        return this.model;
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        return new CollectionOfMultiFieldsEntryPanel(this, this.model);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isAllowEdit()) {
            CollectionOfMultiFieldsEntryPanel panel = (CollectionOfMultiFieldsEntryPanel)this.getPanelVariableEditor();
            panel.setEnabled(enabled);
        }
    }

    private void dataChanged(String action) {
        this.action = action;
        this.fireValueChanged();
    }

    @Override
    public void update(Observable o, Object arg) {
        assert (this.model == o);
        if (o instanceof CollectionOfMultiFieldsModel) {
            CollectionOfMultiFieldsModel.ModelStatus status;
            CollectionOfMultiFieldsModel currModel = (CollectionOfMultiFieldsModel)o;
            if (arg instanceof CollectionOfMultiFieldsModel.ModelStatus && ((status = (CollectionOfMultiFieldsModel.ModelStatus)((Object)arg)).equals((Object)CollectionOfMultiFieldsModel.ModelStatus.NEW_ENTRY_ADDED) || status.equals((Object)CollectionOfMultiFieldsModel.ModelStatus.ENTRY_DELETED))) {
                CollectionOfMultiFieldsEntryPanel panel = (CollectionOfMultiFieldsEntryPanel)this.getPanelVariableEditor();
                panel.updatePanel(currModel);
            }
        }
    }

    public String getAction() {
        return this.action;
    }

    private static class CollectionOfMultiFieldsEntryPanel
    extends AbstractPanelVariableEditor
    implements PanelVariableEditor {
        private static final String BUTTON_ACTION_ADD = "Add Entry";
        private static final String BUTTON_ACTION_ADD_SHORT_DESCRIPTION = "Add a new Entry";
        private static final String BUTTON_ACTION_DELETE = "Delete Entry";
        private static final String BUTTON_ACTION_DELETE_SHORT_DESCRIPTION = "Delete the selected Entry";
        private final transient CollectionOfMultiFieldsEntryVariable variable;
        private final ButtonsPair buttonsPair;

        CollectionOfMultiFieldsEntryPanel(CollectionOfMultiFieldsEntryVariable variable, CollectionOfMultiFieldsModel model) {
            super(new BorderLayout());
            this.variable = variable;
            this.buttonsPair = this.setupPanel();
            this.updatePanel(model);
        }

        @Override
        public boolean isEditorValueValid() {
            return false;
        }

        @Override
        public Object getEditorValue() {
            return null;
        }

        private ButtonsPair setupPanel() {
            ButtonsPair buttonsPanel = new ButtonsPair();
            this.add(buttonsPanel);
            return buttonsPanel;
        }

        void updatePanel(CollectionOfMultiFieldsModel model) {
            this.buttonsPair.addButton.setEnabled(model.canAddEntry());
            this.buttonsPair.deleteButton.setEnabled(model.canDeleteEntry());
        }

        private class ButtonsPair
        extends JPanel {
            private final JButton addButton;
            private final JButton deleteButton;

            ButtonsPair() {
                super(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(1, 0, 1, 4), 0, 0);
                AddEntryAction addAction = new AddEntryAction();
                RemoveEntryAction removeAction = new RemoveEntryAction();
                this.addButton = new JButton(addAction);
                this.deleteButton = new JButton(removeAction);
                this.addButton.setName("CollectionOfMultiFieldsEntryPanel.JButton.Add");
                this.deleteButton.setName("CollectionOfMultiFieldsEntryPanel.JButton.Delete");
                this.add((Component)this.addButton, gbc);
                ++gbc.gridx;
                this.add((Component)this.deleteButton, gbc);
                ++gbc.gridx;
            }
        }

        private class RemoveEntryAction
        extends AbstractAction {
            RemoveEntryAction() {
                this.putValue("ShortDescription", CollectionOfMultiFieldsEntryPanel.BUTTON_ACTION_DELETE_SHORT_DESCRIPTION);
                this.putValue("Name", CollectionOfMultiFieldsEntryPanel.BUTTON_ACTION_DELETE);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionOfMultiFieldsEntryPanel.this.variable.dataChanged(CollectionOfMultiFieldsEntryVariable.ACTION_ENTRY_REMOVED);
            }
        }

        private class AddEntryAction
        extends AbstractAction {
            AddEntryAction() {
                this.putValue("ShortDescription", CollectionOfMultiFieldsEntryPanel.BUTTON_ACTION_ADD_SHORT_DESCRIPTION);
                this.putValue("Name", CollectionOfMultiFieldsEntryPanel.BUTTON_ACTION_ADD);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionOfMultiFieldsEntryPanel.this.variable.dataChanged(CollectionOfMultiFieldsEntryVariable.ACTION_ENTRY_ADDED);
            }
        }
    }
}

