/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.custom.model;

import com.ericsson.em.emm.ere.modifiers.custom.CollectionOfMultiFieldsConfiguration;
import com.ericsson.em.emm.ere.rma.custom.model.CollectionOfMultiFieldsModelEntry;
import com.ericsson.ere.selectiontree.modifiers.AbstractFieldOrientedModifierProfile;
import ericsson.ere.defs.ClassRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.stream.Collectors;

public class CollectionOfMultiFieldsModel
extends Observable
implements Cloneable {
    public static final int MAXIMUM_ENTRIES_ALLOWED = 10;
    private static final int MINIMUM_ENTRIES_ALLOWED = 1;
    public static final int ENTRY_NAME_MAX_LENGTH = 30;
    private Map<String, CollectionOfMultiFieldsModelEntry> model = new HashMap<String, CollectionOfMultiFieldsModelEntry>();
    private String currentDestinationField = null;
    private String currentEntryName = "";

    public void initializeEntries(ClassRepository classRepository, AbstractFieldOrientedModifierProfile profile, CollectionOfMultiFieldsConfiguration configuration) {
        configuration.getEntries().forEach(ctm -> {
            CollectionOfMultiFieldsModelEntry newEntry = CollectionOfMultiFieldsModelEntry.create(classRepository, profile, ctm);
            this.model.put(newEntry.getName(), newEntry);
        });
    }

    public void createEntry(ClassRepository classRepository, AbstractFieldOrientedModifierProfile profile) {
        if (this.currentDestinationField == null) {
            throw new IllegalArgumentException("Destination field was not specified");
        }
        CollectionOfMultiFieldsModelEntry newEntry = CollectionOfMultiFieldsModelEntry.create(classRepository, profile, this.model::size);
        this.currentEntryName = newEntry.getName();
        this.model.put(this.currentEntryName, newEntry);
        this.notify(ModelStatus.NEW_ENTRY_ADDED);
    }

    public void deleteCurrentEntry() {
        if (this.model.size() == 1) {
            throw new IllegalArgumentException("Can't delete last entry");
        }
        this.model.remove(this.currentEntryName);
        this.currentEntryName = new ArrayList<String>(this.model.keySet()).get(0);
        this.notify(ModelStatus.ENTRY_DELETED);
    }

    public List<String> getEntryNames() {
        return new ArrayList<String>(this.model.keySet());
    }

    public CollectionOfMultiFieldsModelEntry getCurrentEntry() {
        if (this.currentEntryName.isEmpty()) {
            throw new IllegalArgumentException("currentEntryName wasn't initialized");
        }
        return this.model.get(this.currentEntryName);
    }

    public boolean isEntitiesEmpty() {
        return this.model.isEmpty();
    }

    public boolean canDeleteEntry() {
        return this.model.size() > 1;
    }

    public boolean canAddEntry() {
        return this.model.size() < 10;
    }

    public void updateEntryName(String newName) {
        if (!this.currentEntryName.equals(newName)) {
            CollectionOfMultiFieldsModelEntry newEntry = CollectionOfMultiFieldsModelEntry.create(newName, this.model.remove(this.currentEntryName));
            this.model.put(newName, newEntry);
            this.currentEntryName = newName;
            this.notify(ModelStatus.ENTRY_NAME_UPDATED);
        }
    }

    public String getCurrentEntryName() {
        return this.currentEntryName;
    }

    public void setCurrentEntryName(String entryName) {
        if (!this.currentEntryName.equals(entryName)) {
            if (!this.model.containsKey(entryName)) {
                throw new IllegalArgumentException("There is no entry exists for defined " + entryName);
            }
            this.currentEntryName = entryName;
            this.notify(ModelStatus.ENTRY_SELECTED);
        }
    }

    public String getCurrentDestinationField() {
        return this.currentDestinationField;
    }

    public void setCurrentDestinationField(String currentDestinationField) {
        this.currentDestinationField = currentDestinationField;
    }

    public List<CollectionOfMultiFieldsModelEntry> getEntries() {
        return new ArrayList<CollectionOfMultiFieldsModelEntry>(this.model.values());
    }

    public String getModelDescription() {
        String res = this.model.values().stream().map(Object::toString).collect(Collectors.joining(", "));
        return String.format("%s = [%s]", this.currentDestinationField, res);
    }

    private void notify(ModelStatus status) {
        this.setChanged();
        this.notifyObservers((Object)status);
    }

    public CollectionOfMultiFieldsModel clone() throws CloneNotSupportedException {
        CollectionOfMultiFieldsModel clone = (CollectionOfMultiFieldsModel)super.clone();
        clone.model = new HashMap<String, CollectionOfMultiFieldsModelEntry>(this.model);
        clone.currentDestinationField = this.currentDestinationField;
        clone.currentEntryName = this.currentEntryName;
        return clone;
    }

    public static enum ModelStatus {
        NEW_ENTRY_ADDED,
        ENTRY_DELETED,
        ENTRY_SELECTED,
        ENTRY_NAME_UPDATED;

    }
}

