/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.connector;

import com.ericsson.em.emm.ere.operations.request.MultipartRequest;
import com.ericsson.em.emm.ere.rma.connector.CredentialExpiredException;
import com.ericsson.em.emm.ere.rma.connector.CredentialMustBeChangedException;
import com.ericsson.em.emm.ere.rma.connector.RequestBody;
import com.ericsson.em.emm.ere.rma.connector.SSLContextConstants;
import com.ericsson.em.emm.ere.rma.connector.UrlNotFoundException;
import com.ericsson.lwac.http.types.ErrorArgument;
import com.ericsson.lwac.http.types.ErrorResponse;
import com.ericsson.lwac.http.xml.LoginErrorResponseMessage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public final class XmlHttpClient {
    private static final String URL_NOT_FOUND = "URL not found";
    private final URL mUrl;
    private final Map<Class<?>, Marshaller> mMarshallers = new ConcurrentHashMap();
    private final Map<Class<?>, Unmarshaller> mUnmarshallers = new ConcurrentHashMap();
    private transient String mCookies;
    private final HttpClient mHttpClient;

    public XmlHttpClient(String url) throws MalformedURLException {
        this.mUrl = new URL(url);
        this.mHttpClient = new DefaultHttpClient();
    }

    public XmlHttpClient(String url, int timeoutSeconds) throws MalformedURLException {
        this.mUrl = new URL(url);
        this.mHttpClient = new DefaultHttpClient();
        HttpParams params = this.mHttpClient.getParams();
        HttpConnectionParams.setSoTimeout(params, timeoutSeconds * 1000);
    }

    public URL getUrl() {
        return this.mUrl;
    }

    public void initTrustStore(String keyStorePath, String keyStorePassword, int port) throws IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext context;
        if (keyStorePath != null && !keyStorePath.isBlank()) {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream instream = new FileInputStream(keyStorePath);){
                if (keyStorePassword != null && !keyStorePassword.isEmpty()) {
                    keyStore.load(instream, keyStorePassword.toCharArray());
                } else {
                    keyStore.load(instream, null);
                }
            }
            context = SSLContexts.custom().loadKeyMaterial(keyStore, keyStorePassword != null ? keyStorePassword.toCharArray() : null).loadTrustMaterial(keyStore).build();
        } else {
            context = SSLContexts.createSystemDefault();
        }
        SSLSocketFactory socketFactory = new SSLSocketFactory(context, SSLContextConstants.defaultProtocols.toArray(new String[SSLContextConstants.defaultProtocols.size()]), SSLContextConstants.defaultCiphers.toArray(new String[SSLContextConstants.defaultCiphers.size()]), SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        Scheme sch = new Scheme("https", port, socketFactory);
        this.mHttpClient.getConnectionManager().getSchemeRegistry().register(sch);
    }

    public void close() {
        if (this.mHttpClient != null) {
            this.mHttpClient.getConnectionManager().shutdown();
        }
    }

    public <Rq, Re> Re post(String operation, Rq request, Class<Rq> requestClass, Class<Re> responseClass) throws IOException, JAXBException {
        HttpPost httpPost = this.createPostMethod(operation, null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (requestClass != null) {
            Marshaller marshaller = this.mMarshallers.get(requestClass);
            if (marshaller == null) {
                JAXBContext context = JAXBContext.newInstance(requestClass);
                marshaller = context.createMarshaller();
                this.mMarshallers.put(requestClass, marshaller);
            }
            marshaller.marshal(request, stream);
        }
        stream.flush();
        ByteArrayEntity entity = new ByteArrayEntity(stream.toByteArray());
        entity.setContentType(new BasicHeader("Content-Type", "text/xml; charset=UTF-8"));
        httpPost.setEntity(entity);
        return this.execute(httpPost, responseClass);
    }

    public <Rq> InputStream post(String operation, Rq request, Class<Rq> requestClass) throws IOException, JAXBException {
        HttpPost httpPost = this.createPostMethod(operation, null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (requestClass != null) {
            Marshaller marshaller = this.mMarshallers.get(requestClass);
            if (marshaller == null) {
                JAXBContext context = JAXBContext.newInstance(requestClass);
                marshaller = context.createMarshaller();
                this.mMarshallers.put(requestClass, marshaller);
            }
            marshaller.marshal(request, stream);
        }
        stream.flush();
        ByteArrayEntity entity = new ByteArrayEntity(stream.toByteArray());
        entity.setContentType(new BasicHeader("Content-Type", "text/xml; charset=UTF-8"));
        httpPost.setEntity(entity);
        return this.execute(httpPost);
    }

    public <Re> Re post(Map<String, String> extraHeaders, String operation, byte[] bytes, Class<Re> responseClass) throws IOException, JAXBException {
        HttpPost httpPost = this.createPostMethod(operation, extraHeaders);
        ByteArrayEntity entity = new ByteArrayEntity(bytes);
        entity.setContentType(new BasicHeader("Content-Type", "text/xml; charset=UTF-8"));
        httpPost.setEntity(entity);
        return this.execute(httpPost, responseClass);
    }

    public <Rq extends MultipartRequest, Re> Re put(String operation, Rq request, Class<Rq> requestClass, Class<Re> responseClass) throws IOException, JAXBException {
        MultipartEntity entity = new MultipartEntity();
        InputStream payload = request.getPayload();
        request.setPayload(null);
        entity.addPart("request", new RequestBody<Rq>(request));
        entity.addPart("payload", new InputStreamBody(payload, ContentType.APPLICATION_OCTET_STREAM));
        HttpPost httpPost = this.createPostMethod(operation, null);
        httpPost.setEntity(entity);
        return this.execute(httpPost, responseClass);
    }

    private HttpPost createPostMethod(String operation, Map<String, String> extraHeaders) {
        HttpPost post = new HttpPost(this.mUrl.toString() + "/" + operation);
        if (this.mCookies != null) {
            post.addHeader(new BasicHeader("Cookie", this.mCookies));
        }
        if (extraHeaders != null) {
            for (Map.Entry<String, String> headerEntry : extraHeaders.entrySet()) {
                post.removeHeaders(headerEntry.getKey());
                post.addHeader(new BasicHeader(headerEntry.getKey(), headerEntry.getValue()));
            }
        }
        return post;
    }

    private <Re> InputStream execute(HttpPost httpPost) throws IOException, JAXBException {
        HttpResponse response = this.mHttpClient.execute(httpPost);
        HttpEntity entity = response.getEntity();
        InputStream content = null;
        if (entity != null) {
            content = entity.getContent();
        }
        switch (response.getStatusLine().getStatusCode()) {
            case 200: {
                if (response.getFirstHeader("Set-Cookie") != null) {
                    this.mCookies = response.getFirstHeader("Set-Cookie").getValue();
                }
                return content;
            }
            case 500: {
                ErrorResponse errorResponse = this.unmarshal(content, ErrorResponse.class);
                throw new IOException(this.createErrorMessage(errorResponse));
            }
            case 401: {
                this.onUnauthorized(entity);
                throw new SecurityException(SecurityErrorEnum.SECURITY_UNAUTHORIZED.getValue());
            }
            case 403: {
                throw new SecurityException(SecurityErrorEnum.SECURITY_FORBIDDEN.getValue());
            }
        }
        throw new IOException(response.getStatusLine().getReasonPhrase());
    }

    private <Re> Re execute(HttpPost httpPost, Class<Re> responseClass) throws IOException, JAXBException {
        HttpResponse response = this.mHttpClient.execute(httpPost);
        HttpEntity entity = response.getEntity();
        try (InputStream content = entity.getContent();){
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    if (response.getFirstHeader("Set-Cookie") != null) {
                        this.mCookies = response.getFirstHeader("Set-Cookie").getValue();
                    }
                    Re Re = responseClass == null ? null : (Re)this.unmarshal(content, responseClass);
                    return Re;
                }
                case 500: {
                    ErrorResponse errorResponse = this.unmarshal(content, ErrorResponse.class);
                    throw new IOException(this.createErrorMessage(errorResponse));
                }
                case 302: {
                    throw new CredentialMustBeChangedException("Must change password");
                }
                case 401: {
                    this.onUnauthorized(entity);
                    throw new SecurityException(SecurityErrorEnum.SECURITY_UNAUTHORIZED.getValue());
                }
                case 403: {
                    throw new SecurityException(SecurityErrorEnum.SECURITY_FORBIDDEN.getValue());
                }
                case 404: {
                    throw new UrlNotFoundException(URL_NOT_FOUND);
                }
            }
            throw new IOException(response.getStatusLine().getReasonPhrase());
        }
    }

    private void onUnauthorized(HttpEntity entity) throws IllegalStateException, IOException {
        if (entity.getContentLength() > 0L) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
            try {
                String error = reader.readLine();
                if (LoginErrorResponseMessage.CREDENTIAL_MUST_BE_CHANGED.getResponseMessage().equals(error)) {
                    throw new CredentialMustBeChangedException(error);
                }
                if (LoginErrorResponseMessage.CREDENTIAL_EXPIRED.getResponseMessage().equals(error)) {
                    throw new CredentialExpiredException(error);
                }
                throw new SecurityException(SecurityErrorEnum.SECURITY_UNAUTHORIZED.getValue());
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private <Re> Re unmarshal(InputStream inputStream, Class<Re> responseClass) throws JAXBException, IOException {
        Unmarshaller unmarshaller = this.mUnmarshallers.get(responseClass);
        if (unmarshaller == null) {
            JAXBContext context = JAXBContext.newInstance(responseClass);
            unmarshaller = context.createUnmarshaller();
            this.mUnmarshallers.put(responseClass, unmarshaller);
        }
        return (Re)unmarshaller.unmarshal(inputStream);
    }

    private String createErrorMessage(ErrorResponse errorResponse) {
        StringBuilder message = new StringBuilder();
        message.append(' ');
        message.append(errorResponse.getErrorCode().charAt(0));
        message.append(errorResponse.getErrorCode().substring(1).toLowerCase().replace('_', ' '));
        if (errorResponse.getArguments() != null) {
            for (ErrorArgument argument : errorResponse.getArguments()) {
                message.append(", ");
                message.append(argument.getName());
                message.append(' ');
                message.append(argument.getValue());
            }
        }
        return message.toString();
    }

    public static enum SecurityErrorEnum {
        SECURITY_FORBIDDEN("Forbidden"),
        SECURITY_UNAUTHORIZED("Unauthorized");

        private final String mValue;

        private SecurityErrorEnum(String value) {
            this.mValue = value;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

