/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.connector;

import com.ericsson.em.emc.util.XmlFactory;
import com.ericsson.em.emm.ere.operations.request.SetTreeRequest;
import com.ericsson.em.emm.ere.rma.connector.EreConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.connector.RatingRuleTreeConnector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.w3c.dom.Element;

public final class EreTreeConnector
implements RatingRuleTreeConnector {
    private final EreConnector mEreConnector;
    private final String mServiceProviderName;
    private final String mServiceName;
    private final String mPlanName;
    private final String mPeriodName;
    private final DateTime mStartDate;
    private static final DateTimeFormatter ISO_DATE_TIME = DateTimeFormat.forPattern("yyyyMMdd'T'HHmmssSSS");

    public EreTreeConnector(EreConnector ereConnector, String serviceProviderName, String serviceName, String planName, String periodName, DateTime startDate) {
        this.mEreConnector = ereConnector;
        this.mServiceProviderName = serviceProviderName;
        this.mServiceName = serviceName;
        this.mPlanName = planName;
        this.mPeriodName = periodName;
        this.mStartDate = startDate;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void updateRatingPlan(Element newStructureXML) throws EreCommunicationException {
        try {
            SetTreeRequest request = new SetTreeRequest();
            request.setServiceProviderName(this.mServiceProviderName);
            request.setServiceName(this.mServiceName);
            request.setPlanName(this.mPlanName);
            request.setPeriodName(this.mPeriodName);
            request.setStartDate(ISO_DATE_TIME.print(this.mStartDate));
            ByteArrayOutputStream payload = new ByteArrayOutputStream();
            TransformerFactory transformerFactory = XmlFactory.newTransformerFactory();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(newStructureXML);
            StreamResult result = new StreamResult(payload);
            transformer.transform(source, result);
            request.setPayload(new ByteArrayInputStream(payload.toByteArray()));
            this.mEreConnector.put("settree", request, SetTreeRequest.class);
        }
        catch (Exception e) {
            throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this.mEreConnector, e.getMessage(), e);
        }
    }
}

