/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.connector;

import com.ericsson.charging.common.RMAStatusInterface;
import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class EreNameDocument
extends PlainDocument
implements FieldValidation {
    private final Pattern mPattern = Pattern.compile("^[\\p{IsAlphabetic}\\p{IsDigit}\\p{Blank}_]{1,32}$");
    private transient StatusInterface myStatusHandler = new RMAStatusInterface();
    private boolean myIsEnabled = true;

    @Override
    public void enableValidation(boolean enable) {
        this.myIsEnabled = enable;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (this.myIsEnabled && !this.mPattern.matcher(proposedResult).matches()) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Text can only contain alphabetic, digits, _ or whitespace and must be between 1 and 32 characters.");
            return;
        }
        this.myStatusHandler.printMessage("");
        super.insertString(offs, str, a);
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        boolean removeToEmpty;
        boolean bl = removeToEmpty = offs == 0 && len == this.getLength();
        if (this.myIsEnabled && removeToEmpty) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("The text cannot be an empty string.");
        }
        super.remove(offs, len);
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        return this.mPattern.matcher(value).matches();
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        this.myStatusHandler = statusHandler;
    }
}

