/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.connector;

import com.ericsson.em.emc.util.XmlFactory;
import com.ericsson.em.emm.ere.operations.request.ActivateTreeRequest;
import com.ericsson.em.emm.ere.operations.request.CreateTreeRequest;
import com.ericsson.em.emm.ere.operations.request.DeactivateTreeRequest;
import com.ericsson.em.emm.ere.operations.request.GetManagerRequest;
import com.ericsson.em.emm.ere.operations.request.GetTreeRequest;
import com.ericsson.em.emm.ere.operations.request.MoveTreeRequest;
import com.ericsson.em.emm.ere.operations.request.MultipartRequest;
import com.ericsson.em.emm.ere.operations.request.RemoveTreeRequest;
import com.ericsson.em.emm.ere.operations.response.ActivateTreeResponse;
import com.ericsson.em.emm.ere.operations.response.DeactivateTreeResponse;
import com.ericsson.em.emm.ere.operations.response.MoveTreeResponse;
import com.ericsson.em.emm.ere.operations.response.RemoveTreeResponse;
import com.ericsson.em.emm.ere.rma.connector.CredentialChangeDialog;
import com.ericsson.em.emm.ere.rma.connector.CredentialExpiredException;
import com.ericsson.em.emm.ere.rma.connector.CredentialMustBeChangedException;
import com.ericsson.em.emm.ere.rma.connector.EreNewRatingPeriodProxyEditor;
import com.ericsson.em.emm.ere.rma.connector.EreTreeConnector;
import com.ericsson.em.emm.ere.rma.connector.KeyStorePasswordDialog;
import com.ericsson.em.emm.ere.rma.connector.LoginInformationDialog;
import com.ericsson.em.emm.ere.rma.connector.UrlNotFoundException;
import com.ericsson.em.emm.ere.rma.connector.XmlHttpClient;
import com.ericsson.em.m3if.provisioning.v1_1.getadminuserlastlogin.GetAdminUserLastLoginRequest;
import com.ericsson.em.m3if.provisioning.v1_1.getadminuserlastlogin.GetAdminUserLastLoginResponse;
import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionController;
import com.ericsson.ere.functioncontrol.FunctionControllerProvider;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultNavigatorNodeEditor;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultNewServiceProxyEditor;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultRatingPeriodProxySettingsEditor;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultSaveAsRatingPeriodProxyEditor;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultServiceProxySettingsEditor;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.lwac.http.types.ChangePasswordRequest;
import com.ericsson.lwac.http.types.Credential;
import com.ericsson.lwac.http.types.GetPermissionsRequest;
import com.ericsson.lwac.http.types.GetPermissionsResponse;
import com.ericsson.lwac.http.types.LoginRequest;
import com.ericsson.lwac.http.types.Permission;
import com.ericsson.lwac.utilities.XmlUtils;
import ericsson.ere.gui.Config;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.ActiveSavedConnector;
import ericsson.ere.integration.connector.CanceledEreLoginException;
import ericsson.ere.integration.connector.ChargingConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.connector.RatingRuleTreeConnector;
import ericsson.ere.integration.proxy.RatingPlanAndPeriodProxy;
import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.Service;
import ericsson.ere.xml.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class EreConnector
extends AbstractConnector
implements FunctionControllerProvider,
FunctionController,
ActiveSavedConnector,
ChargingConnector,
RatingPlanAndPeriodProxy {
    private static final String URL = "URL";
    private static final String KEYSTORE = "KeyStore";
    private static final Logger logger = LoggerFactory.getLogger(EreConnector.class);
    private SettingsMap settings;
    private XmlHttpClient client;
    private Element managerDocument;
    private final Set<String> permissions = new HashSet<String>();

    @Override
    public boolean supportGetPropertyCommand() {
        return true;
    }

    @Override
    public boolean supportsActivate() {
        return true;
    }

    @Override
    public boolean supportsDeactivate() {
        return true;
    }

    @Override
    public void init(String type, SettingsMap settings) throws EreCommunicationException {
        if (this.settings == null) {
            this.settings = settings;
        } else {
            this.settings.updateParametersFrom(settings);
        }
    }

    @Override
    public SettingsMap getErePropertyMap() {
        return this.settings;
    }

    @Override
    public String getId() {
        return this.getURL();
    }

    @Override
    public String getProperty(String key) {
        Parameter parameter = this.settings.getParameter(key);
        if (parameter != null) {
            return parameter.getValue();
        }
        return null;
    }

    @Override
    public boolean isAlive() {
        return this.client != null && this.managerDocument != null;
    }

    @Override
    public void disConnect() {
        if (this.client != null) {
            try {
                this.client.post("logout", null, null, null);
            }
            catch (Exception e) {
                logger.error("Error while disconnecting", e);
            }
            this.client.close();
            this.client = null;
            this.managerDocument = null;
        }
    }

    @Override
    public String getRatingManagerName() {
        return this.managerDocument != null ? this.managerDocument.getAttribute("Name") : "Unknown";
    }

    @Override
    public void refreshRatingManagerDocument() throws EreCommunicationException {
        this.connect();
        if (this.isConnected()) {
            this.refreshPermissions();
            GetManagerRequest request = new GetManagerRequest();
            try (InputStream inputStream = this.get("getmanager", request, GetManagerRequest.class);){
                this.managerDocument = XmlUtils.getDocument(inputStream).getDocumentElement();
            }
            catch (Exception e) {
                throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, e.getMessage(), e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(XmlUtils.documentToString(this.managerDocument.getOwnerDocument()));
            }
        }
    }

    @Override
    public Element getServiceElement(String serviceName) throws EreCommunicationException {
        Element serviceListElement;
        if (logger.isDebugEnabled()) {
            logger.debug(serviceName);
        }
        if (this.managerDocument != null && (serviceListElement = XMLUtil.getFirstElementNamed("ServiceList", this.managerDocument)) != null) {
            for (Element serviceElement : XMLUtil.getElementNodesNamed("Service", serviceListElement.getChildNodes())) {
                if (!serviceName.equals(XMLUtil.getAttributeFromElement(serviceElement, "Name", null))) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug(XmlUtils.elementToString(serviceElement));
                }
                Element clonedNode = (Element)serviceElement.cloneNode(true);
                Document document = XMLUtil.createEmptyDocument();
                document.adoptNode(clonedNode);
                document.appendChild(clonedNode);
                return clonedNode;
            }
        }
        return null;
    }

    @Override
    public Service getService(String serviceName) throws EreCommunicationException {
        Element serviceDefinitionElement;
        Element serviceElement;
        if (logger.isDebugEnabled()) {
            logger.debug(serviceName);
        }
        if ((serviceElement = this.getServiceElement(serviceName)) != null && (serviceDefinitionElement = XMLUtil.getFirstElementNamed("ServiceDefinition", serviceElement)) != null) {
            Service service = new Service(serviceName);
            try {
                service.startService(serviceDefinitionElement);
            }
            catch (Exception e) {
                throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, e.getMessage(), e);
            }
            return service;
        }
        return null;
    }

    @Override
    public String[] getServiceList() throws EreCommunicationException {
        Element serviceListElement;
        ArrayList<String> serviceList = new ArrayList<String>();
        if (this.managerDocument != null && (serviceListElement = XMLUtil.getFirstElementNamed("ServiceList", this.managerDocument)) != null) {
            for (Element serviceElement : XMLUtil.getElementNodesNamed("Service", serviceListElement.getChildNodes())) {
                String serviceName = XMLUtil.getAttributeFromElement(serviceElement, "Name", null);
                if (serviceName == null) continue;
                serviceList.add(serviceName);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}", (Object)serviceList);
        }
        return serviceList.toArray(new String[serviceList.size()]);
    }

    @Override
    public Element getServiceListElement() throws EreCommunicationException {
        Element serviceListElement;
        if (logger.isDebugEnabled()) {
            logger.debug("");
        }
        if (this.managerDocument != null && (serviceListElement = XMLUtil.getFirstElementNamed("ServiceList", this.managerDocument)) != null) {
            return serviceListElement;
        }
        return null;
    }

    @Override
    public List<String> getServiceProviderList() throws EreCommunicationException {
        Element serviceProviderListElement;
        LinkedList<String> serviceProviderList = new LinkedList<String>();
        if (this.managerDocument != null && (serviceProviderListElement = XMLUtil.getFirstElementNamed("ServiceProviderList", this.managerDocument)) != null) {
            for (Element serviceProviderElement : XMLUtil.getElementNodesNamed("ServiceProvider", serviceProviderListElement.getChildNodes())) {
                String serviceProviderName = XMLUtil.getAttributeFromElement(serviceProviderElement, "Name", null);
                if (serviceProviderName == null) continue;
                serviceProviderList.add(serviceProviderName);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}", (Object)serviceProviderList);
        }
        return serviceProviderList;
    }

    @Override
    public List<String> getRatingPlanNameList(String serviceProviderName) throws EreCommunicationException {
        Element serviceProviderListElement;
        LinkedList<String> ratingPlanNameList = new LinkedList<String>();
        if (this.managerDocument != null && (serviceProviderListElement = XMLUtil.getFirstElementNamed("ServiceProviderList", this.managerDocument)) != null) {
            for (Element serviceProviderElement : XMLUtil.getElementNodesNamed("ServiceProvider", serviceProviderListElement.getChildNodes())) {
                if (!serviceProviderName.equals(XMLUtil.getAttributeFromElement(serviceProviderElement, "Name", null))) continue;
                for (Element ratingPlanElement : XMLUtil.getElementNodesNamed("RatingPlan", serviceProviderElement.getChildNodes())) {
                    String ratingPlanName = XMLUtil.getAttributeFromElement(ratingPlanElement, "Name", null);
                    if (ratingPlanName == null) continue;
                    ratingPlanNameList.add(ratingPlanName);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}", (Object)ratingPlanNameList);
        }
        return ratingPlanNameList;
    }

    @Override
    public Element getRatingPlanElement(String serviceProviderName, String ratingPlanName) throws EreCommunicationException {
        Element ratingPlanElement;
        Element serviceProviderElement;
        Element serviceProviderListElement;
        if (logger.isDebugEnabled()) {
            logger.debug("{}, {}", (Object)serviceProviderName, (Object)ratingPlanName);
        }
        if (this.managerDocument != null && (serviceProviderListElement = XMLUtil.getFirstElementNamed("ServiceProviderList", this.managerDocument)) != null && (serviceProviderElement = (Element)EreConnector.getElementWithNameAndAttribute("ServiceProvider", "Name", serviceProviderName, serviceProviderListElement.getChildNodes())) != null && (ratingPlanElement = (Element)EreConnector.getElementWithNameAndAttribute("RatingPlan", "Name", ratingPlanName, serviceProviderElement.getChildNodes())) != null) {
            return ratingPlanElement;
        }
        return null;
    }

    @Override
    public void createRatingPlan(ServiceProviderProxy serviceProviderProxy, SettingsMap newValues) throws EreCommunicationException {
        if (logger.isDebugEnabled()) {
            for (String key : newValues.getParametersKeySet()) {
                logger.debug("{} = '{}'", (Object)key, (Object)newValues.getParameterAsString(key));
            }
        }
    }

    @Override
    public void createRatingPeriod(RatingPlanProxy ratingPlanProxy, SettingsMap newValues, Element newStructureXML) throws EreCommunicationException {
        try {
            if (logger.isDebugEnabled()) {
                for (String key : newValues.getParametersKeySet()) {
                    logger.debug("{} = '{}'", (Object)key, (Object)newValues.getParameterAsString(key));
                }
                logger.debug(XmlUtils.elementToString(newStructureXML));
            }
            String serviceProviderName = ratingPlanProxy.getServiceProviderProxy().getName();
            String periodName = newValues.getParameterAsString("Name");
            String planName = ratingPlanProxy.getName();
            String serviceName = ratingPlanProxy.getServiceName();
            String startDate = newValues.getParameterAsString("Start date");
            CreateTreeRequest request = new CreateTreeRequest();
            request.setServiceProviderName(serviceProviderName);
            request.setServiceName(serviceName);
            request.setPlanName(planName);
            request.setPeriodName(periodName);
            request.setStartDate(startDate);
            ByteArrayOutputStream payload = new ByteArrayOutputStream();
            Transformer transformer = this.newTransformer();
            DOMSource source = new DOMSource(newStructureXML);
            StreamResult result = new StreamResult(payload);
            transformer.transform(source, result);
            request.setPayload(new ByteArrayInputStream(payload.toByteArray()));
            this.put("createtree", request, CreateTreeRequest.class);
        }
        catch (Exception e) {
            throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, e.getMessage(), e);
        }
    }

    @Override
    public Element getRatingPeriodRuleTree(RatingPeriodProxy ratingPeriodProxy) throws EreCommunicationException {
        Element element;
        block19: {
            String serviceProviderName = ratingPeriodProxy.getServiceProviderName();
            String periodName = ratingPeriodProxy.getName();
            String planName = ratingPeriodProxy.getParentRatingPlanProxy().getName();
            String serviceName = ratingPeriodProxy.getServiceName();
            String startDate = DateUtil.formatISODateTime(ratingPeriodProxy.getRatingPeriodTime().getCalendar(), true);
            if (logger.isDebugEnabled()) {
                logger.debug("{}/{}/{}", serviceProviderName, planName, periodName);
            }
            GetTreeRequest request = new GetTreeRequest();
            request.setServiceProviderName(serviceProviderName);
            request.setServiceName(serviceName);
            request.setPlanName(planName);
            request.setPeriodName(periodName);
            request.setStartDate(startDate);
            if (ratingPeriodProxy.isSelectedActive()) {
                Element element2;
                block18: {
                    InputStream inputStream = this.get("getactivetree", request, GetTreeRequest.class);
                    try {
                        Document document = XmlUtils.getDocument(inputStream);
                        Element periodElement = document.createElement("RatingPeriod");
                        periodElement.setAttribute("Name", periodName);
                        periodElement.setAttribute("StartDate", startDate);
                        Element tariffElement = document.getDocumentElement();
                        document.removeChild(tariffElement);
                        periodElement.appendChild(tariffElement);
                        element2 = periodElement;
                        if (inputStream == null) break block18;
                    }
                    catch (Throwable document) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable periodElement) {
                                    document.addSuppressed(periodElement);
                                }
                            }
                            throw document;
                        }
                        catch (IOException | ParserConfigurationException | SAXException e) {
                            throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, e.getMessage(), e);
                        }
                    }
                    inputStream.close();
                }
                return element2;
            }
            InputStream inputStream = this.get("getsavedtree", request, GetTreeRequest.class);
            try {
                Document document = XmlUtils.getDocument(inputStream);
                Element periodElement = document.createElement("RatingPeriod");
                periodElement.setAttribute("Name", periodName);
                periodElement.setAttribute("StartDate", startDate);
                Element tariffElement = document.getDocumentElement();
                document.removeChild(tariffElement);
                periodElement.appendChild(tariffElement);
                element = periodElement;
                if (inputStream == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, e.getMessage(), e);
                }
            }
            inputStream.close();
        }
        return element;
    }

    @Override
    public RatingRuleTreeConnector getRatingRuleTreeConnector(RatingPeriodProxy ratingPeriodProxy) throws EreCommunicationException {
        String serviceProviderName = ratingPeriodProxy.getServiceProviderName();
        String periodName = ratingPeriodProxy.getName();
        String planName = ratingPeriodProxy.getParentRatingPlanProxy().getName();
        String serviceName = ratingPeriodProxy.getServiceName();
        DateTime startDate = new DateTime(ratingPeriodProxy.getRatingPeriodTime().getCalendar());
        return new EreTreeConnector(this, serviceProviderName, serviceName, planName, periodName, startDate);
    }

    @Override
    public void updateRatingPeriod(RatingPeriodProxy ratingPeriodProxy, SettingsMap newValues) throws EreCommunicationException {
        if (logger.isDebugEnabled()) {
            for (String key : newValues.getParametersKeySet()) {
                logger.debug("{} = '{}'", (Object)key, (Object)newValues.getParameterAsString(key));
            }
        }
        String serviceProviderName = ratingPeriodProxy.getServiceProviderName();
        String periodName = ratingPeriodProxy.getName();
        String planName = ratingPeriodProxy.getParentRatingPlanProxy().getName();
        String serviceName = ratingPeriodProxy.getServiceName();
        String startDate = DateUtil.formatISODateTime(ratingPeriodProxy.getRatingPeriodTime().getCalendar(), true);
        String newPeriodName = newValues.getParameterAsString("Name");
        String newStartDate = newValues.getParameterAsString("Start date");
        MoveTreeRequest request = new MoveTreeRequest();
        request.setServiceProviderName(serviceProviderName);
        request.setServiceName(serviceName);
        request.setPlanName(planName);
        request.setPeriodName(periodName);
        request.setStartDate(startDate);
        request.setNewPeriodName(newPeriodName);
        request.setNewStartDate(newStartDate);
        if (ratingPeriodProxy.isSelectedActive()) {
            this.send("moveactivetree", request, MoveTreeRequest.class, MoveTreeResponse.class);
        } else {
            this.send("movetree", request, MoveTreeRequest.class, MoveTreeResponse.class);
        }
    }

    @Override
    public void activateRatingPeriod(RatingPeriodProxy ratingPeriodProxy) throws EreCommunicationException {
        String serviceProviderName = ratingPeriodProxy.getServiceProviderName();
        String periodName = ratingPeriodProxy.getName();
        String planName = ratingPeriodProxy.getParentRatingPlanProxy().getName();
        String serviceName = ratingPeriodProxy.getServiceName();
        String startDate = DateUtil.formatISODateTime(ratingPeriodProxy.getRatingPeriodTime().getCalendar(), true);
        ActivateTreeRequest request = new ActivateTreeRequest();
        request.setServiceProviderName(serviceProviderName);
        request.setServiceName(serviceName);
        request.setPlanName(planName);
        request.setPeriodName(periodName);
        request.setStartDate(startDate);
        this.send("activatetree", request, ActivateTreeRequest.class, ActivateTreeResponse.class);
    }

    @Override
    public void deActivateRatingPeriod(RatingPeriodProxy ratingPeriodProxy) throws EreCommunicationException {
        String serviceProviderName = ratingPeriodProxy.getServiceProviderName();
        String periodName = ratingPeriodProxy.getName();
        String planName = ratingPeriodProxy.getParentRatingPlanProxy().getName();
        String serviceName = ratingPeriodProxy.getServiceName();
        String startDate = DateUtil.formatISODateTime(ratingPeriodProxy.getRatingPeriodTime().getCalendar(), true);
        if (logger.isDebugEnabled()) {
            logger.debug("{}", (Object)ratingPeriodProxy.isSelectedActive());
        }
        DeactivateTreeRequest request = new DeactivateTreeRequest();
        request.setServiceProviderName(serviceProviderName);
        request.setServiceName(serviceName);
        request.setPlanName(planName);
        request.setPeriodName(periodName);
        request.setStartDate(startDate);
        this.send("deactivatetree", request, DeactivateTreeRequest.class, DeactivateTreeResponse.class);
    }

    @Override
    public void removeRatingPeriod(RatingPeriodProxy ratingPeriodProxy) throws EreCommunicationException {
        String serviceProviderName = ratingPeriodProxy.getServiceProviderName();
        String periodName = ratingPeriodProxy.getName();
        String planName = ratingPeriodProxy.getParentRatingPlanProxy().getName();
        String serviceName = ratingPeriodProxy.getServiceName();
        String startDate = DateUtil.formatISODateTime(ratingPeriodProxy.getRatingPeriodTime().getCalendar(), true);
        if (logger.isDebugEnabled()) {
            logger.debug("{}", (Object)ratingPeriodProxy.isSelectedActive());
        }
        RemoveTreeRequest request = new RemoveTreeRequest();
        request.setServiceProviderName(serviceProviderName);
        request.setServiceName(serviceName);
        request.setPlanName(planName);
        request.setPeriodName(periodName);
        request.setStartDate(startDate);
        this.send("removetree", request, RemoveTreeRequest.class, RemoveTreeResponse.class);
    }

    @Override
    public RatingPlanAndPeriodProxy getSpecialProxy(AbstractEreProxy proxy) {
        return this;
    }

    @Override
    public void createRatingPlanAndPeriod(SettingsMap newValues, Element newStructureXML) throws EreCommunicationException {
        try {
            if (logger.isDebugEnabled()) {
                for (String key : newValues.getParametersKeySet()) {
                    logger.debug("{} = '{}'", (Object)key, (Object)newValues.getParameterAsString(key));
                }
                logger.debug(XmlUtils.elementToString(newStructureXML));
            }
            String serviceProviderName = newValues.getParameterAsString("Service");
            String periodName = newValues.getParameterAsString("Name");
            String planName = newValues.getParameterAsString("Ratingplan");
            String serviceName = newValues.getParameterAsString("Service");
            String startDate = newValues.getParameterAsString("Start date");
            CreateTreeRequest request = new CreateTreeRequest();
            request.setServiceProviderName(serviceProviderName);
            request.setServiceName(serviceName);
            request.setPlanName(planName);
            request.setPeriodName(periodName);
            request.setStartDate(startDate);
            ByteArrayOutputStream payload = new ByteArrayOutputStream();
            Transformer transformer = this.newTransformer();
            DOMSource source = new DOMSource(newStructureXML);
            StreamResult result = new StreamResult(payload);
            transformer.transform(source, result);
            request.setPayload(new ByteArrayInputStream(payload.toByteArray()));
            this.put("createtree", request, CreateTreeRequest.class);
        }
        catch (Exception e) {
            throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, e.getMessage(), e);
        }
    }

    private Transformer newTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = XmlFactory.newTransformerFactory();
        return transformerFactory.newTransformer();
    }

    @Override
    public Class<?> getEditProxyEditorForClass(Class<?> editorFor) {
        if (editorFor == RatingPeriodProxy.class) {
            return DefaultRatingPeriodProxySettingsEditor.class;
        }
        if (editorFor == ServiceProxy.class) {
            return DefaultServiceProxySettingsEditor.class;
        }
        return DefaultNavigatorNodeEditor.class;
    }

    @Override
    public Class<?> getCreateProxyEditorForClass(Class<?> editorFor) {
        if (editorFor == RatingPeriodProxy.class) {
            return EreNewRatingPeriodProxyEditor.class;
        }
        if (editorFor == ServiceProxy.class) {
            return DefaultNewServiceProxyEditor.class;
        }
        return DefaultNavigatorNodeEditor.class;
    }

    @Override
    public Class<?> getSaveAsProxyEditorForClass() {
        return DefaultSaveAsRatingPeriodProxyEditor.class;
    }

    @Override
    public FunctionController getFunctionController() {
        return this;
    }

    private String getURL() {
        return this.getProperty(URL);
    }

    private String getKeyStore() {
        return this.getProperty(KEYSTORE);
    }

    private String getName() {
        return this.settings.getParameterAsString("Name");
    }

    @Override
    public FunctionState getStateForFunction(FunctionToken paramFunctionToken, FunctionContext paramFunctionContext) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}", (Object)paramFunctionToken);
        }
        switch (paramFunctionToken) {
            case SHOW_SERVICE_LIST: {
                if (this.hasPermission("ROLE_ERE_VIEW_SERVICE")) {
                    return FunctionState.createFunctionState(FunctionState.State.ON);
                }
                return FunctionState.createFunctionState(FunctionState.State.OFF);
            }
            case ALLOW_SERVICEPROVIDERLIST_MENU: {
                return FunctionState.createFunctionState(FunctionState.State.OFF);
            }
            case CHANGE_RATING_PERIOD_PROPERTIES: {
                RatingPeriodProxy proxy = (RatingPeriodProxy)paramFunctionContext.getProxy();
                if (proxy.isSelectedActive()) {
                    return FunctionState.createFunctionState(FunctionState.State.OFF);
                }
                if (this.hasPermission("ROLE_ERE_MOVE_TREE")) {
                    return FunctionState.createFunctionState(FunctionState.State.ON);
                }
                return FunctionState.createFunctionState(FunctionState.State.OFF);
            }
            case IMPORT_ALLOWED: 
            case NEW_RATING_PERIOD: {
                if (this.hasPermission("ROLE_ERE_CREATE_TREE")) {
                    return FunctionState.createFunctionState(FunctionState.State.ON);
                }
                return FunctionState.createFunctionState(FunctionState.State.OFF);
            }
            case SAVE_SELECTION_TREE: {
                RatingPeriodProxy proxy = (RatingPeriodProxy)paramFunctionContext.getProxy();
                if (proxy.isSelectedActive()) {
                    return FunctionState.createFunctionState(FunctionState.State.OFF);
                }
                if (this.hasPermission("ROLE_ERE_UPDATE_TREE")) {
                    return FunctionState.createFunctionState(FunctionState.State.ON);
                }
                return FunctionState.createFunctionState(FunctionState.State.OFF);
            }
            case DELETE_RATING_PERIOD: {
                if (this.hasPermission("ROLE_ERE_REMOVE_TREE")) {
                    return FunctionState.createFunctionState(FunctionState.State.ON);
                }
                return FunctionState.createFunctionState(FunctionState.State.OFF);
            }
        }
        return null;
    }

    public <Rq, Re> Re send(String operation, Rq request, Class<Rq> requestClass, Class<Re> responseClass) throws EreCommunicationException {
        try {
            return this.client.post(operation, request, requestClass, responseClass);
        }
        catch (Exception e) {
            throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, e.getMessage(), e);
        }
    }

    public <Rq> InputStream get(String operation, Rq request, Class<Rq> requestClass) throws EreCommunicationException {
        try {
            return this.client.post(operation, request, requestClass);
        }
        catch (Exception e) {
            throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, e.getMessage(), e);
        }
    }

    public <Rq extends MultipartRequest> void put(String operation, Rq request, Class<Rq> requestClass) throws EreCommunicationException {
        try {
            this.client.put(operation, request, requestClass, null);
        }
        catch (Exception e) {
            throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, e.getMessage(), e);
        }
    }

    private XmlHttpClient newXmlHttpClient() throws EreCommunicationException {
        try {
            return new XmlHttpClient(this.getURL(), 30);
        }
        catch (MalformedURLException mfue) {
            throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "ERE Application URL is not correct", mfue);
        }
    }

    private boolean connect() throws EreCommunicationException {
        if (this.isAlive()) {
            return true;
        }
        Config.UserInfo userInfo = DialogFactory.showLoginDialog(this.getName(), "");
        if (userInfo == null) {
            throw new CanceledEreLoginException(null, "User cancelled the login.");
        }
        if (userInfo.myUsername.isEmpty() || userInfo.myPassword.isEmpty()) {
            throw new EreCommunicationException(this, "User name or password is blank");
        }
        this.disConnect();
        XmlHttpClient tmpClient = this.newXmlHttpClient();
        try {
            if (this.isHttps()) {
                String keyStorePassword = null;
                String keyStore = this.getKeyStore();
                if (keyStore != null && !keyStore.isBlank()) {
                    try {
                        keyStorePassword = KeyStorePasswordDialog.getPassword();
                    }
                    catch (Exception e) {
                        throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "Unable to get key store password", e);
                    }
                    if (keyStorePassword == null) {
                        throw new CanceledEreLoginException(this, "User cancelled the login.");
                    }
                }
                try {
                    tmpClient.initTrustStore(keyStore, keyStorePassword, this.getPort());
                }
                catch (FileNotFoundException x) {
                    throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "KeyStore path does not exist", x);
                }
                catch (UnrecoverableKeyException x) {
                    throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "KeyStore password is incorrect", x);
                }
                catch (CertificateException x) {
                    throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "certificates in the keystore could not be loaded", x);
                }
                catch (NoSuchAlgorithmException x) {
                    throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "No Such Algorithm used to check integrity of the KeyStroe", x);
                }
                catch (KeyManagementException x) {
                    throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "Either Key Authorization failed or Key already expired", x);
                }
                catch (KeyStoreException x) {
                    throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "Invalid KeyStore", x);
                }
                catch (IOException x) {
                    throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "Keystore was tampered with, or password was incorrect", x);
                }
            }
            LoginRequest loginRequest = new LoginRequest(userInfo.myUsername, new Credential(userInfo.myPassword, "password"));
            try {
                tmpClient.post("login", loginRequest, LoginRequest.class, null);
            }
            catch (SSLPeerUnverifiedException x) {
                throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "TLS Peer unverified", x);
            }
            catch (SSLHandshakeException x) {
                throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "TLS Handshake failed", x);
            }
            catch (IOException x) {
                throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "Error occurred while sending request to server", x);
            }
            catch (JAXBException x) {
                throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "Error occurred while parsing request", x);
            }
            catch (UrlNotFoundException x) {
                throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "URL not found, please check", x);
            }
            catch (SecurityException x) {
                throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "Unauthorized Access", x);
            }
        }
        catch (CredentialMustBeChangedException e) {
            String newPassword;
            DialogFactory.getErrorDialog("Authentication failed", "Password must be changed.");
            try {
                newPassword = CredentialChangeDialog.newPassword();
            }
            catch (Exception x) {
                throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, "Failed to get new password", x);
            }
            if (newPassword != null && newPassword.isEmpty()) {
                ChangePasswordRequest loginRequest = new ChangePasswordRequest(new Credential(userInfo.myPassword, "password"), new Credential(newPassword, "password"));
                try {
                    tmpClient.post("changepassword", loginRequest, ChangePasswordRequest.class, null);
                }
                catch (IOException x) {
                    throw new EreCommunicationException(this, "Server communication error while changing password");
                }
                catch (JAXBException x) {
                    throw new EreCommunicationException(this, "Parsing error while changing password");
                }
            }
            throw new EreCommunicationException(this, "New password must not be blank");
        }
        catch (CredentialExpiredException x) {
            throw new EreCommunicationException(this, "Credential has expired");
        }
        this.client = tmpClient;
        try {
            GetAdminUserLastLoginRequest request = new GetAdminUserLastLoginRequest();
            GetAdminUserLastLoginResponse response = this.client.post("getadminuserlastlogin", request, GetAdminUserLastLoginRequest.class, GetAdminUserLastLoginResponse.class);
            if (response.getLastLogin() != null) {
                LoginInformationDialog.showLoginInformation(response);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private int getPort() throws MalformedURLException {
        return new URL(this.getURL()).getPort();
    }

    private void refreshPermissions() throws EreCommunicationException {
        this.permissions.clear();
        if (this.isConnected()) {
            try {
                GetPermissionsRequest request = new GetPermissionsRequest();
                GetPermissionsResponse response = this.client.post("getpermissions", request, GetPermissionsRequest.class, GetPermissionsResponse.class);
                if (response.getPermissions() != null) {
                    for (Permission permission : response.getPermissions()) {
                        this.permissions.add(permission.getName());
                    }
                }
            }
            catch (Exception e) {
                throw new EreCommunicationException((ericsson.ere.integration.connector.EreConnector)this, e.getMessage(), e);
            }
        }
    }

    private boolean hasPermission(String permission) {
        return this.permissions.contains(permission);
    }

    private boolean isConnected() {
        return this.client != null;
    }

    private boolean isHttps() {
        return this.getURL().startsWith("https:");
    }

    private static Node getElementWithNameAndAttribute(String name, String attrName, String attrValue, NodeList list) {
        List<Element> elements = XMLUtil.getElementNodesNamed(name, list);
        for (Element e : elements) {
            if (!e.hasAttributes()) continue;
            NamedNodeMap attrs = e.getAttributes();
            int nattr = attrs.getLength();
            for (int a = 0; a < nattr; ++a) {
                Node attr = attrs.item(a);
                if (!attrName.equalsIgnoreCase(attr.getNodeName()) || !attrValue.equals(attr.getNodeValue())) continue;
                return e;
            }
        }
        return null;
    }
}

