/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma;

import com.ericsson.em.emm.ere.modifiers.StringFormatterFieldConfiguration;
import com.ericsson.em.emm.ere.rma.ExtendedStringVariable;
import com.ericsson.ere.selectiontree.HierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.modifiers.AbstractFieldOrientedModifierProfile;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class StringFormatterFieldModifierProfile
extends AbstractFieldOrientedModifierProfile {
    private static final String LBL_FIELD = "Field";
    private static final String MSG_NO_FIELDS_EXISTS = "No available fields found";

    @Override
    public List<Variable> getVariables() {
        return this.getVariables("", "");
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        StringFormatterFieldConfiguration config = StringFormatterFieldConfiguration.create(new ParseContextAdapter(null, iterator, null));
        return this.getVariables(config.getFieldName(), config.getFormat());
    }

    private List<Variable> getVariables(String destinationFieldName, String format) {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        List<FieldDefinition> destinationFields = this.extractDestinationFields();
        Variable fieldsDropDown = StringFormatterFieldModifierProfile.createFieldsDropDown(destinationFieldName, destinationFields, LBL_FIELD);
        l.add(fieldsDropDown);
        l.add(new StringVariable("Format", format));
        l.add(new ExtendedStringVariable("Info", false));
        return l;
    }

    @Override
    public String[] getTreeDefinedFieldInUse(List<Variable> profileState) {
        String fieldName = VarListUtil.getValueStringForName(profileState, LBL_FIELD);
        String format = VarListUtil.getValueStringForName(profileState, "Format");
        List<FieldDefinition> fields = this.getAllFields();
        LinkedList<String> fieldsInUse = new LinkedList<String>();
        fieldsInUse.add(fieldName);
        int position = 0;
        int start = -1;
        int end = -1;
        do {
            if ((start = format.indexOf("${", position)) == -1) continue;
            end = format.indexOf(125, start);
            if (end == -1) {
                position = start + 2;
                continue;
            }
            String variableName = format.substring(start + 2, end);
            if (StringFormatterFieldModifierProfile.findInList(fields, variableName)) {
                fieldsInUse.add(variableName);
            }
            position = end + 1;
        } while (start != -1);
        return fieldsInUse.toArray(new String[fieldsInUse.size()]);
    }

    private List<FieldDefinition> getAllFields() {
        return AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository).withHierarchicalFields().buildFieldDefinitionList();
    }

    private static boolean findInList(List<FieldDefinition> fields, String variableName) {
        for (FieldDefinition field : fields) {
            if (!field.getFieldName().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        return null;
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        if ("Format".equals(value.getLabel())) {
            String validationErrors = this.checkValidity(value);
            ExtendedStringVariable info = StringFormatterFieldModifierProfile.findExtendedStringVariable(vars);
            info.setValid(validationErrors == null);
            info.setValue(validationErrors == null ? "" : validationErrors);
        }
        return false;
    }

    private static ExtendedStringVariable findExtendedStringVariable(List<Variable> vars) {
        for (Variable var : vars) {
            if (!(var instanceof ExtendedStringVariable)) continue;
            return (ExtendedStringVariable)var;
        }
        return null;
    }

    private String checkValidity(Variable value) {
        List<FieldDefinition> fields = this.getAllFields();
        String format = value.getValueString();
        int position = 0;
        int start = -1;
        int end = -1;
        do {
            if ((start = format.indexOf("${", position)) == -1) continue;
            end = format.indexOf(125, start);
            if (end == -1) {
                return "Unclosed bracket; An open bracket '${' has no closing bracket '}'";
            }
            String variableName = format.substring(start + 2, end);
            if ("".equals(variableName)) {
                return "Empty bracket";
            }
            if (!StringFormatterFieldModifierProfile.findInList(fields, variableName)) {
                return "Not found; " + variableName;
            }
            position = end + 1;
        } while (start != -1);
        return null;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String fieldName = VarListUtil.getValueStringForName(variables, LBL_FIELD);
        String format = VarListUtil.getValueStringForName(variables, "Format");
        StringFormatterFieldConfiguration config = new StringFormatterFieldConfiguration(fieldName, format);
        PluginConfigurationHelper.writeXML(config, out, indentLevel, indentMarker);
    }

    private List<FieldDefinition> extractDestinationFields() {
        AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository);
        builder.withHierarchicalFields().withFilter(new TargetHierarchicalFieldFilter()).withConstraints(this, null);
        return builder.buildFieldDefinitionList();
    }

    private static Variable createFieldsDropDown(String selectedFieldName, List<FieldDefinition> fields, String label) {
        if (fields.isEmpty() && "".equals(selectedFieldName)) {
            return new NotAllowedVariable(label, MSG_NO_FIELDS_EXISTS);
        }
        String defaultFieldName = selectedFieldName;
        if (selectedFieldName.trim().isEmpty() && !fields.isEmpty()) {
            defaultFieldName = fields.get(0).getCanonicalName();
        }
        return FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(label, label, fields, defaultFieldName);
    }

    private class TargetHierarchicalFieldFilter
    implements HierarchicalFieldFilter {
        private final List<String> allowedTypes = Arrays.asList("OUT", "INTERNAL", "VARIABLE");

        private TargetHierarchicalFieldFilter() {
        }

        private boolean isOfAllowedComplexType(FieldDefinition def) {
            FieldHierarchyNode.ComplexType type = def.getComplexType();
            boolean isSetOrNone = type == FieldHierarchyNode.ComplexType.SET || type == FieldHierarchyNode.ComplexType.NONE;
            boolean isParentNullSetOrNone = true;
            FieldStructure parent = def.getParent();
            if (parent != null) {
                FieldHierarchyNode.ComplexType parentType = parent.getComplexType();
                isParentNullSetOrNone = parentType == FieldHierarchyNode.ComplexType.SET || parentType == FieldHierarchyNode.ComplexType.NONE;
            }
            return isSetOrNone && isParentNullSetOrNone;
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            boolean allowed = false;
            if (field.isLeaf() && field instanceof FieldDefinition) {
                FieldDefinition def = (FieldDefinition)field;
                boolean isRightType = this.allowedTypes.contains(def.getParameterType());
                boolean isVisible = ClassRepositoryHelper.fieldIsCommonOrVisibleContextField(def, StringFormatterFieldModifierProfile.this.myClassRepository);
                boolean isString = def.getTypedDataType() == DataType.STRING;
                allowed = isString && isRightType && isVisible && this.isOfAllowedComplexType(def) && !field.isKey();
            }
            return allowed;
        }
    }
}

