/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.operations.validation.impl;

import com.ericsson.em.emm.ere.operations.validation.IsEreDateTimeString;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class IsEreDateTimeStringValidator
implements ConstraintValidator<IsEreDateTimeString, String> {
    private static final String ISO_8601_FORMAT = "yyyyMMdd'T'HHmmssSSS";

    @Override
    public void initialize(IsEreDateTimeString parameters) {
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        try {
            return this.validateIso8601(value);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean validateIso8601(String value) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern(ISO_8601_FORMAT);
        DateTime date = dateTimeFormatter.parseDateTime(value);
        return date.getYear() >= 1000 && date.getEra() != 0;
    }
}

