/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.modifiers;

import com.ericsson.em.emm.ere.instruction.InstructionExecutor;
import com.ericsson.em.emm.ere.instruction.string.SimpleStringInstruction;
import com.ericsson.em.emm.ere.instruction.string.StringInstructionBuilder;
import com.ericsson.em.emm.ere.modifiers.EreDataFieldStringInstruction;
import com.ericsson.em.emm.ere.modifiers.StringFormatterFieldConfiguration;
import com.ericsson.ere.annotations.ConfigurationClass;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;

@Immutable
@ConfigurationClass(value=StringFormatterFieldConfiguration.class)
public class StringFormatterFieldModifier
extends ImmutableModifier {
    protected final String myFormat;
    protected final String myFieldName;
    protected final InstructionExecutor<String, DataSet> myExecutor;
    protected final DataSetField myFieldDataSetField;

    protected StringFormatterFieldModifier(ParseContext ctx) {
        super(ctx);
        StringFormatterFieldConfiguration conf = StringFormatterFieldConfiguration.create(ctx);
        this.myFormat = conf.getFormat();
        this.myFieldName = conf.getFieldName();
        this.myFieldDataSetField = StringFormatterFieldModifier.createDataSetField(this.myFieldName, ctx);
        this.myExecutor = this.buildInstructions(ctx);
    }

    private InstructionExecutor<String, DataSet> buildInstructions(ParseContext ctx) {
        StringInstructionBuilder<DataSet> sib = new StringInstructionBuilder<DataSet>();
        int position = 0;
        int start = -1;
        int end = -1;
        while (true) {
            if ((start = this.myFormat.indexOf("${", position)) == -1) {
                if (position != this.myFormat.length()) {
                    sib.addInstruction(new SimpleStringInstruction(this.myFormat.substring(position, this.myFormat.length())));
                }
                return sib.getExecutor();
            }
            end = this.myFormat.indexOf(125, start);
            if (end == -1) {
                sib.addInstruction(new SimpleStringInstruction(this.myFormat.substring(position, start)));
                position = start + 2;
                continue;
            }
            if (end == start + 2) {
                position = end;
                continue;
            }
            sib.addInstruction(new SimpleStringInstruction(this.myFormat.substring(position, start)));
            String variableName = this.myFormat.substring(start + 2, end);
            DataSetField dataSetField = StringFormatterFieldModifier.createDataSetField(variableName, ctx);
            if (dataSetField != null) {
                sib.addInstruction(new EreDataFieldStringInstruction(dataSetField));
            }
            position = end + 1;
        }
    }

    private static DataSetField createDataSetField(String key, ParseContext ctx) {
        FieldDefinition def = ctx.getClassRepository().getFieldDefinitionByName(key);
        DataSetField field = new DataSetField(def, def.getTypedDataType());
        return field;
    }

    public static StringFormatterFieldModifier create(ParseContext ctx, TariffStructureNode[] children) {
        return new StringFormatterFieldModifier(ctx);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public String describeTrace(TracePoint tp) {
        return "";
    }

    @Override
    public void perform(DataSet theData) {
        String actual = this.myExecutor.execute(theData);
        this.myFieldDataSetField.setValueInDataSet(theData, actual);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myFormat == null ? 0 : this.myFormat.hashCode()) + (this.myFieldName == null ? 0 : this.myFieldName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringFormatterFieldModifier other = (StringFormatterFieldModifier)obj;
        if (this.myFormat == null ? other.myFormat != null : !this.myFormat.equals(other.myFormat)) {
            return false;
        }
        return !(this.myFieldName == null ? other.myFieldName != null : !this.myFieldName.equals(other.myFieldName));
    }
}

