/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class WaitableQueue<T> {
    private final Lock mOutstandingLock = new ReentrantLock();
    private final Condition mQueueIsEmpty = this.mOutstandingLock.newCondition();
    private final Condition mQueueNotEmpty = this.mOutstandingLock.newCondition();
    private final Set<T> mTotalQueue = new HashSet<T>();
    private final Queue<T> mWaitingQueue = new LinkedList<T>();

    public void add(T item) {
        try {
            this.mOutstandingLock.lock();
            if (this.mTotalQueue.contains(item)) {
                if (!this.mWaitingQueue.contains(item)) {
                    this.mWaitingQueue.add(item);
                }
            } else {
                this.mWaitingQueue.add(item);
                this.mTotalQueue.add(item);
            }
            this.mQueueNotEmpty.signal();
        }
        finally {
            this.mOutstandingLock.unlock();
        }
    }

    public T takeNext() {
        block7: {
            try {
                this.mOutstandingLock.lock();
                if (this.mWaitingQueue.isEmpty()) {
                    if (this.mQueueNotEmpty.await(100L, TimeUnit.MILLISECONDS)) {
                        T t = this.mWaitingQueue.remove();
                        return t;
                    }
                    break block7;
                }
                T t = this.mWaitingQueue.remove();
                return t;
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.mOutstandingLock.unlock();
            }
        }
        return null;
    }

    public int countOngoing() {
        try {
            this.mOutstandingLock.lock();
            int n = this.mTotalQueue.size();
            return n;
        }
        finally {
            this.mOutstandingLock.unlock();
        }
    }

    public void markDone(T item) {
        try {
            this.mOutstandingLock.lock();
            this.mTotalQueue.remove(item);
            if (this.mTotalQueue.isEmpty()) {
                this.mQueueIsEmpty.signalAll();
            }
        }
        finally {
            this.mOutstandingLock.unlock();
        }
    }

    public void waitForCompletion() {
        try {
            this.mOutstandingLock.lock();
            while (!this.mTotalQueue.isEmpty()) {
                this.mQueueIsEmpty.await();
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.mOutstandingLock.unlock();
        }
    }

    public T poll() {
        try {
            this.mOutstandingLock.lock();
            T t = this.mWaitingQueue.poll();
            return t;
        }
        finally {
            this.mOutstandingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<? super T> result) {
        try {
            T t;
            this.mOutstandingLock.lock();
            int nitems = 0;
            while ((t = this.mWaitingQueue.poll()) != null) {
                result.add(t);
                this.mTotalQueue.remove(t);
                ++nitems;
            }
            result.addAll(this.mTotalQueue);
            this.mTotalQueue.clear();
            this.mQueueIsEmpty.signalAll();
            int n = nitems += this.mTotalQueue.size();
            return n;
        }
        finally {
            this.mOutstandingLock.unlock();
        }
    }
}

