/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.util;

import com.ericsson.em.emc.util.Currency;
import com.ericsson.em.emc.util.Money;
import com.ericsson.em.emc.util.RoundingError;
import com.ericsson.em.emc.util.RoundingMethod;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public final class Amount
implements Comparable<Amount>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Amount ZERO = new Amount(BigInteger.ZERO, BigInteger.ONE);
    private final BigInteger numerator;
    private final BigInteger denominator;

    private Amount(BigInteger n, BigInteger d) {
        BigInteger gcd;
        BigInteger numerator = n;
        BigInteger denominator = d;
        if (d.signum() == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (denominator.compareTo(BigInteger.ZERO) < 0) {
            numerator = numerator.negate();
            denominator = denominator.abs();
        }
        if ((gcd = numerator.gcd(denominator)).compareTo(BigInteger.ONE) > 0) {
            numerator = numerator.divide(gcd);
            denominator = denominator.divide(gcd);
        }
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public static Amount valueOf(String amountStr) {
        BigDecimal bignum = new BigDecimal(amountStr);
        return Amount.fromBigDecimal(bignum);
    }

    public static Amount fromBigDecimal(BigDecimal bignum) {
        BigInteger bigintNumerator = null;
        BigInteger bigintDenominator = null;
        int scale = bignum.scale();
        if (scale < 0) {
            BigDecimal intPart = bignum.scaleByPowerOfTen(scale);
            bigintNumerator = intPart.toBigIntegerExact().multiply(BigInteger.TEN.pow(-scale));
            bigintDenominator = BigInteger.ONE;
        } else if (scale > 0) {
            BigDecimal intPart = bignum.scaleByPowerOfTen(scale);
            bigintNumerator = intPart.toBigIntegerExact();
            bigintDenominator = BigInteger.TEN.pow(scale);
        } else {
            bigintNumerator = bignum.toBigIntegerExact();
            bigintDenominator = BigInteger.ONE;
        }
        return new Amount(bigintNumerator, bigintDenominator);
    }

    public BigDecimal toBigDecimal(int wantedScale, RoundingMode roundingMode) {
        BigDecimal n = new BigDecimal(this.numerator);
        BigDecimal d = new BigDecimal(this.denominator);
        return n.divide(d, wantedScale, roundingMode);
    }

    public static Amount valueOf(Money money) {
        return Amount.fromBigDecimal(money.toBigDecimal());
    }

    public Money toMoney(RoundingError roundingError, RoundingMethod method, Currency currency) {
        return this.toMoney(roundingError, method, RoundingMode.HALF_UP, currency);
    }

    public Money toMoney(RoundingError roundingError, RoundingMethod method, RoundingMode roundingMode, Currency currency) {
        int numberOfDecimals = currency.getDefaultFractionDigits() < 0 ? 2 : currency.getDefaultFractionDigits();
        Amount originalAmount = new Amount(this.numerator, this.denominator);
        if (method == RoundingMethod.INCLUDED) {
            Amount errorAmount = roundingError.getAndClear();
            originalAmount = originalAmount.add(errorAmount);
        }
        BigDecimal scaled = originalAmount.toBigDecimal(numberOfDecimals, roundingMode);
        Amount scaledAsAmount = Amount.fromBigDecimal(scaled);
        Amount remainder = originalAmount.subtract(scaledAsAmount);
        roundingError.addRemainder(remainder);
        return Money.valueOf(scaled, currency);
    }

    public Amount add(Amount other) {
        BigInteger n1 = this.numerator;
        BigInteger d1 = this.denominator;
        BigInteger n2 = other.numerator;
        BigInteger d2 = other.denominator;
        BigInteger n1d2 = n1.multiply(d2);
        BigInteger n2d1 = n2.multiply(d1);
        BigInteger d1d2 = d1.multiply(d2);
        BigInteger numerator = n1d2.add(n2d1);
        BigInteger denominator = d1d2;
        return new Amount(numerator, denominator);
    }

    public Amount multiply(Amount other) {
        BigInteger n1 = this.numerator;
        BigInteger d1 = this.denominator;
        BigInteger n2 = other.numerator;
        BigInteger d2 = other.denominator;
        BigInteger numerator = n1.multiply(n2);
        BigInteger denominator = d1.multiply(d2);
        return new Amount(numerator, denominator);
    }

    public Amount divide(Amount other) {
        BigInteger n1 = this.numerator;
        BigInteger d1 = this.denominator;
        BigInteger n2 = other.numerator;
        BigInteger d2 = other.denominator;
        BigInteger numerator = n1.multiply(d2);
        BigInteger denominator = d1.multiply(n2);
        return new Amount(numerator, denominator);
    }

    public Amount subtract(Amount other) {
        BigInteger n1 = this.numerator;
        BigInteger d1 = this.denominator;
        BigInteger n2 = other.numerator;
        BigInteger d2 = other.denominator;
        BigInteger n1d2 = n1.multiply(d2);
        BigInteger n2d1 = n2.multiply(d1);
        BigInteger d1d2 = d1.multiply(d2);
        BigInteger numerator = n1d2.subtract(n2d1);
        BigInteger denominator = d1d2;
        return new Amount(numerator, denominator);
    }

    public Amount negate() {
        return new Amount(this.numerator.negate(), this.denominator);
    }

    public Amount abs() {
        if (this.numerator.compareTo(BigInteger.ZERO) < 0) {
            return this.negate();
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.denominator == null ? 0 : this.denominator.hashCode());
        result = 31 * result + (this.numerator == null ? 0 : this.numerator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Amount other = (Amount)obj;
        if (this.denominator == null ? other.denominator != null : !this.denominator.equals(other.denominator)) {
            return false;
        }
        return !(this.numerator == null ? other.numerator != null : !this.numerator.equals(other.numerator));
    }

    @Override
    public int compareTo(Amount other) {
        BigInteger n1 = this.numerator;
        BigInteger d1 = this.denominator;
        BigInteger n2 = other.numerator;
        BigInteger d2 = other.denominator;
        BigInteger n1d2 = n1.multiply(d2);
        BigInteger n2d1 = n2.multiply(d1);
        return n1d2.compareTo(n2d1);
    }

    public String toString() {
        return String.format("%d/%d~~%.2f", this.numerator, this.denominator, this.numerator.doubleValue() / this.denominator.doubleValue());
    }

    public boolean lessThan(Amount other) {
        return this.compareTo(other) < 0;
    }

    public boolean greaterThan(Amount other) {
        return this.compareTo(other) > 0;
    }
}

