/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.tag.persistence;

import com.ericsson.em.emc.tag.persistence.Tag;
import com.ericsson.em.emc.tag.persistence.TagDAO;
import com.ericsson.lwac.cache.Cache;
import com.ericsson.lwac.cache.CacheService;
import com.ericsson.lwac.cache.LockingType;
import com.ericsson.lwac.cache.SecondaryCache;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.Singleton;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

@Updatable
@Singleton
@Validatable
@CryptoKeys(keyAliases={"emm.tag.S"})
public class TagDAOBean
extends CryptoExtendedBaseEntityDAOBean<Tag>
implements TagDAO {
    private static final String TABLE_NAME = "emm$tag";
    private static final String COL_ID = "id";
    private static final String COL_NAME = "name";
    private static final String COL_DESCRIPTION = "description";
    private static final String COL_NAME_HASH = "namehash";
    private static final String COL_STATISTICS = "statistics";
    private static final String COL_FINGERPRINT = "fingerprint";
    private static final String COL_FINGERPRINTVERSION = "fingerprintversion";
    private static final String COL_FINGERPRINTKEYGENERATION = "fingerprintkeygeneration";
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    static final String FINGERPRINT_KEY = "emm.tag.S";
    private static final String SEQUENCE_NAME = "emm$tag_seq";
    @Resource
    private CacheService cacheService;
    private Cache<Long, Tag> cache;
    private static final String[] COLUMNS = new String[]{"id", "name", "description", "namehash", "statistics", "fingerprint", "fingerprintversion", "fingerprintkeygeneration"};

    protected int assign(BaseEntity entity, PreparedStatement statement) throws SQLException {
        byte[] nameHash;
        Tag tag = (Tag)entity;
        int i = 1;
        statement.setString(i++, tag.getName());
        statement.setString(i++, tag.getDescription());
        try {
            nameHash = TagDAOBean.digest(tag.getName());
            statement.setBytes(i++, nameHash);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        statement.setBoolean(i++, tag.isStatistics());
        i = this.assignFingerprint(statement, i, new Object[]{tag.getName(), tag.getDescription(), nameHash, tag.isStatistics()});
        return i;
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        Tag tag = (Tag)baseEntity;
        tag.setName(resultSet.getString(COL_NAME));
        tag.setDescription(resultSet.getString(COL_DESCRIPTION));
        tag.setStatistics(resultSet.getBoolean(COL_STATISTICS));
        resultSet.getBytes(COL_NAME_HASH);
    }

    protected Tag createManagedEntity() {
        return new Tag();
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getColumns() {
        return COLUMNS;
    }

    public String getSequenceName() {
        return SEQUENCE_NAME;
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isUpdatable() {
        return true;
    }

    public boolean isVersionable() {
        return false;
    }

    @Override
    public Tag create(Tag tag) {
        tag = (Tag)super.create((BaseEntity)tag);
        this.updateCache(tag);
        return tag;
    }

    @Override
    public Tag update(Tag tag) {
        this.updateCache(tag);
        return (Tag)super.update((BaseEntity)tag);
    }

    @Override
    public Tag find(long id, boolean useCache) {
        Tag tag = null;
        if (useCache) {
            tag = this.cache.getByPrimaryId(id);
        }
        if (tag == null && (tag = (Tag)super.find(id)) != null) {
            this.updateCache(tag);
        }
        return tag;
    }

    @Override
    public Tag find(String tagName, boolean useCache) {
        Tag tag = null;
        if (useCache) {
            tag = this.cache.getBySecondaryId(TagSecondaryCache.NAME, tagName);
        }
        if (tag == null) {
            try {
                tag = (Tag)super.find(this.getSelectStatement() + " WHERE " + COL_NAME_HASH + " = ?", new Object[]{TagDAOBean.digest(tagName)});
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            if (tag != null) {
                this.updateCache(tag);
            }
        }
        return tag;
    }

    @Override
    public List<Tag> findAll() {
        return super.findMultiple(this.getSelectStatement(), new Object[0]);
    }

    @Override
    public List<Tag> findWithFingerprintVersion(int version) {
        return this.findMultiple(this.getSelectStatement() + " where fingerprintversion = ?", new Object[]{version});
    }

    @Override
    public void delete(long id) {
        super.delete("delete from " + this.getTableName() + " where " + COL_ID + " = ?", new Object[]{id});
        this.cache.remove(id);
    }

    protected void updateCache(Tag tag) {
        this.cache.update(tag.getId(), tag, new SecondaryCache[]{TagSecondaryCache.NAME}, new String[]{tag.getName()}, LockingType.optimistic);
    }

    @PostConstruct
    public void postConstruct() {
        this.cache = this.cacheService.createCache(Long.class, Tag.class, true);
        this.cache.addSecondaryCache(TagSecondaryCache.NAME);
    }

    protected String getEntitySimpleName() {
        return Tag.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getString(COL_NAME), resultSet.getString(COL_DESCRIPTION), resultSet.getBytes(COL_NAME_HASH), resultSet.getBoolean(COL_STATISTICS)};
        }
        return null;
    }

    private static byte[] digest(String tagName) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest instance = MessageDigest.getInstance("SHA1");
        return instance.digest(tagName.toLowerCase().getBytes("UTF-8"));
    }

    static enum TagSecondaryCache implements SecondaryCache
    {
        NAME("namehash");

        private final String name;

        private TagSecondaryCache(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

