/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.readonly;

import com.ericsson.em.emc.operations.readonly.ReadOnlyOperations;
import com.ericsson.em.emc.readonly.ReadOnlyOperationRoutingService;
import com.ericsson.em.emc.readonly.ReadOnlySettings;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.security.session.SessionContext;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Service
public class ReadOnlyOperationRoutingServiceBean
implements ReadOnlyOperationRoutingService {
    @Resource
    private SessionContext sessionContext;
    private final Map<ReadOnlyOperations, ReadOnlySettings> readOnlyOperationSettings = new ConcurrentHashMap<ReadOnlyOperations, ReadOnlySettings>();

    @Override
    public boolean isRouteToReadOnly(ReadOnlyOperations operation) {
        ReadOnlySettings readOnlySettings = this.readOnlyOperationSettings.get((Object)operation);
        if (readOnlySettings == null || !readOnlySettings.isEnabled()) {
            return false;
        }
        String currentContext = this.sessionContext.getCurrentSession().getProtocol();
        if (readOnlySettings.isIncludeAllContexts()) {
            if (readOnlySettings.getExcludeContexts().isEmpty()) {
                return true;
            }
            return readOnlySettings.getExcludeContexts().stream().noneMatch(currentContext::equalsIgnoreCase);
        }
        return readOnlySettings.getIncludeContexts().stream().anyMatch(currentContext::equalsIgnoreCase);
    }

    @Override
    public void setDownloadRegisteredAccountHolders(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.DOWNLOAD_REGISTERED_ACCOUNTHOLDERS, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for DownloadRegisteredAccountHolders - " + e.getMessage());
        }
    }

    @Override
    public void setGetAccount(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_ACCOUNT, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetAccount - " + e.getMessage());
        }
    }

    @Override
    public void setGetAccounts(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_ACCOUNTS, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetAccounts - " + e.getMessage());
        }
    }

    @Override
    public void setGetAccountHolderAdditionalInformation(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_ACCOUNTHOLDER_ADDITIONAL_INFORMATION, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetAccountHolderAdditionalInformation - " + e.getMessage());
        }
    }

    @Override
    public void setGetAccountHolderAddress(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_ACCOUNTHOLDER_ADDRESS, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetAccountHolderAddress - " + e.getMessage());
        }
    }

    @Override
    public void setGetAccountHolderAliases(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_ACCOUNTHOLDER_ALIASES, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetAccountHolderAliases - " + e.getMessage());
        }
    }

    @Override
    public void setGetAccountHolderIdentification(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_ACCOUNTHOLDER_IDENTIFICATION, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetAccountHolderIdentification - " + e.getMessage());
        }
    }

    @Override
    public void setGetAccountHolderInfo(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_ACCOUNTHOLDER_INFO, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetAccountHolderInfo - " + e.getMessage());
        }
    }

    @Override
    public void setGetAccountHolderPersonalInformation(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_ACCOUNTHOLDER_PERSONAL_INFORMATION, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetAccountHolderPersonalInformation - " + e.getMessage());
        }
    }

    @Override
    public void setGetApprovals(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_APPROVALS, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetApprovals - " + e.getMessage());
        }
    }

    @Override
    public void setGetBalance(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_BALANCE, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetBalance - " + e.getMessage());
        }
    }

    @Override
    public void setGetConnectedAccountHolders(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_CONNECTED_ACCOUNTHOLDERS, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetConnectedAccountHolders - " + e.getMessage());
        }
    }

    @Override
    public void setGetContactList(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_CONTACT_LIST, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetContactList - " + e.getMessage());
        }
    }

    @Override
    public void setGetHierarchyTransactionHistory(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_HIERARCHY_TRANSACTION_HISTORY, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetHierarchyTransactionHistory - " + e.getMessage());
        }
    }

    @Override
    public void setGetRegisteredAccountHolders(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_REGISTERED_ACCOUNTHOLDERS, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetRegisteredAccountHolders - " + e.getMessage());
        }
    }

    @Override
    public void setGetServiceProviderDetails(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_SERVICE_PROVIDER_DETAILS, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetServiceProviderDetails - " + e.getMessage());
        }
    }

    @Override
    public void setGetTransactionHistory(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_TRANSACTION_HISTORY, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetTransactionHistory - " + e.getMessage());
        }
    }

    @Override
    public void setGetTransactionHistoryDetails(List<String> settings) {
        try {
            this.readOnlyOperationSettings.put(ReadOnlyOperations.GET_TRANSACTION_HISTORY_DETAILS, new ReadOnlySettings(settings));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Illegal read-only configuration for GetTransactionHistoryDetails - " + e.getMessage());
        }
    }

    @VisibleForTesting
    void resetSettings() {
        this.readOnlyOperationSettings.clear();
    }
}

