/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.profile.logging;

import com.ericsson.em.emc.hierarchies.HierarchyManager;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileEventEntity;
import com.ericsson.em.emc.logging.ExternalLogManager;
import com.ericsson.em.emc.logging.LogRecord;
import com.ericsson.em.emc.m3externallog.IdentityType;
import com.ericsson.em.emc.m3externallog.LogRecordHeader;
import com.ericsson.em.emc.profile.logging.ProfileEventExternalLogManager;
import com.ericsson.em.emc.profile.logging.ProfileEventLogRecord;
import com.ericsson.em.emc.profile.logging.ProfileEventLogRecordInstruction;
import com.ericsson.em.emc.transactionid.TransactionIdService;
import com.ericsson.lwac.actions.Action;
import com.ericsson.lwac.security.session.Identity;
import com.ericsson.lwac.security.session.Session;
import com.ericsson.lwac.security.session.SessionContext;
import com.ericsson.lwac.transaction.TransactionManager;
import com.ericsson.lwac.transaction.UnstartedTransaction;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;

@Singleton
public class ProfileEventExternalLogManagerBean
implements ProfileEventExternalLogManager {
    @Resource
    private TransactionIdService transactionIdService;
    @Resource
    private SessionContext sessionContext;
    @EJB
    private HierarchyManager hierarchyManager;
    @EJB
    private ExternalLogManager externalLogManager;
    @Resource
    private TransactionManager transactionManager;
    private static final String DEFAULT_PROFILE_VERSION = "1.0";

    @Override
    public void publish(ProfileEventEntity profileEventEntity) {
        StringBuilder profileType = new StringBuilder();
        if (profileEventEntity.getProfileEvent() == ProfileEventEntity.ProfileEvent.DELETED) {
            this.transactionManager.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), Action.unchecked(() -> profileType.append(this.getProfileTypeFromProfileName(profileEventEntity))));
        }
        this.runAfterCommit(() -> this.transactionManager.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), Action.unchecked(() -> {
            ProfileEventLogRecord profileEventLogRecord = new ProfileEventLogRecord();
            profileEventLogRecord.setLogRecordInstruction(this.createLogRecordInstruction(profileEventEntity, profileType.toString()));
            this.setLogRecordHeader(profileEventLogRecord.getLogRecordHeader());
            this.externalLogManager.publish((LogRecord)profileEventLogRecord, null);
        })));
    }

    private ProfileEventLogRecordInstruction createLogRecordInstruction(ProfileEventEntity profileEvent, String profileType) {
        ProfileEventLogRecordInstruction profileEventLogRecordInstruction = new ProfileEventLogRecordInstruction();
        profileEventLogRecordInstruction.setProfileName(profileEvent.getProfileName());
        profileEventLogRecordInstruction.setEventType(profileEvent.getProfileEvent().name());
        if (profileType.isEmpty()) {
            profileType = this.getProfileTypeFromProfileName(profileEvent);
        }
        profileEventLogRecordInstruction.setProfileType(profileType);
        profileEventLogRecordInstruction.setLastUpdatedTimestamp(profileEvent.getTimestamp().toString());
        return profileEventLogRecordInstruction;
    }

    private String getProfileTypeFromProfileName(ProfileEventEntity profileEvent) {
        Profile profile = this.hierarchyManager.findProfile(profileEvent.getProfileName());
        return this.hierarchyManager.findProperty(profile, "General", "Profile Type");
    }

    private void setLogRecordHeader(LogRecordHeader logRecordHeader) {
        logRecordHeader.setInitiatingUser(ProfileEventExternalLogManagerBean.getIdentityType(this.sessionContext.getEffectiveUser()));
        logRecordHeader.setLoggingTime(this.transactionIdService.getTransactionDateTime().toString());
        logRecordHeader.setRealUser(ProfileEventExternalLogManagerBean.getIdentityType(this.sessionContext.getRealUser()));
        Session session = this.sessionContext.getCurrentSession();
        logRecordHeader.setSessionId(session == null ? null : Long.valueOf(session.getSessionId()));
        logRecordHeader.setTransactionId(this.transactionIdService.getTransactionId());
        logRecordHeader.setVersion(DEFAULT_PROFILE_VERSION);
    }

    private static IdentityType getIdentityType(Identity identity) {
        IdentityType identityType = null;
        if (identity != null) {
            identityType = new IdentityType();
            identityType.setId(identity.getUserId());
            identityType.setType(identity.getUserIdType());
        }
        return identityType;
    }

    private void runAfterCommit(Runnable runnable) {
        if (this.transactionManager.getTransaction().isPresent()) {
            this.transactionManager.afterCommit(transactionAction -> runnable.run());
        } else {
            runnable.run();
        }
    }
}

