/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.otp;

import com.ericsson.em.emc.otp.OtpLoginSession;
import com.ericsson.em.emc.otp.OtpLoginSessionRefreshMessage;
import com.ericsson.lwac.cluster.ClusterMessage;
import com.ericsson.lwac.cluster.ClusterMessageListener;
import com.ericsson.lwac.deployer.BeanId;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OtpLoginProvider
implements ClusterMessageListener {
    private static final Logger logger = LoggerFactory.getLogger(OtpLoginProvider.class);
    private final Map<String, OtpLoginSession> currentLoginSessions = new ConcurrentHashMap<String, OtpLoginSession>();
    private final BeanId beanId;

    protected OtpLoginProvider(BeanId beanId) {
        this.beanId = beanId;
    }

    public boolean add(String sessionId, String userId) {
        return this.currentLoginSessions.put(sessionId, new OtpLoginSession(userId)) == null;
    }

    public boolean remove(String sessionId) {
        return this.currentLoginSessions.remove(sessionId) != null;
    }

    public Optional<OtpLoginSession> get(String sessionToken) {
        return Optional.ofNullable(this.currentLoginSessions.get(sessionToken));
    }

    static OtpLoginProvider create(BeanId beanId) {
        return new OtpLoginProvider(beanId);
    }

    @Override
    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public Object handle(ClusterMessage message) {
        if (message.getPayload() instanceof OtpLoginSessionRefreshMessage) {
            logger.debug("Received OtpLoginSessionRefreshMessage.");
            OtpLoginSessionRefreshMessage msg = (OtpLoginSessionRefreshMessage)message.getPayload();
            if (msg.isAddSession()) {
                logger.debug("Adding session ID and user ID '{}' from OtpLoginSessionRefreshMessage to currentLoginSessions for bean ID '{}'.", (Object)msg.getUserId(), (Object)this.beanId.getId());
                this.currentLoginSessions.put(msg.getSessionId(), new OtpLoginSession(msg.getUserId()));
            } else {
                logger.debug("Removing session ID in OtpLoginSessionRefreshMessage from currentLoginSessions for bean ID '{}'.", (Object)this.beanId.getId());
                this.currentLoginSessions.remove(msg.getSessionId());
            }
        }
        return null;
    }
}

