/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.notificationreceiver.persistence;

import com.ericsson.em.emc.notificationreceiver.persistence.NotificationReceiver;
import com.ericsson.em.emc.notificationreceiver.persistence.NotificationReceiverDAO;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Stream;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"emm.notificationreceiver.S"})
public class NotificationReceiverDAOBean
extends CryptoExtendedBaseEntityDAOBean<NotificationReceiver>
implements NotificationReceiverDAO {
    private static final String TABLE_NAME = "emm$notificationreceiver";
    private static final String SEQUENCE_NAME = "emm$notificationreceiver_seq";
    private static final String WHERE_ACCOUNTHOLDER = " where fk_accountholder = ?";
    private static final String WHERE_MSISDN = "and msisdn = ?";
    private static final String WHERE_EMAIL = "and email = ?";
    static final String NOTIFICATION_RECEIVER_FINGERPRINT_KEY = "emm.notificationreceiver.S";

    protected String getEntitySimpleName() {
        return NotificationReceiver.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return NOTIFICATION_RECEIVER_FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 1;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1) {
            return new Object[]{resultSet.getLong(TableColumn.FK_ACCOUNTHOLDER.name()), resultSet.getString(TableColumn.FIRSTNAME.name()), resultSet.getString(TableColumn.SURNAME.name()), resultSet.getString(TableColumn.MSISDN.name()), resultSet.getString(TableColumn.EMAIL.name()), resultSet.getString(TableColumn.LANGUAGECODE.name())};
        }
        return null;
    }

    public String[] getColumns() {
        return (String[])Stream.of(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        NotificationReceiver notificationReceiver = (NotificationReceiver)baseEntity;
        preparedStatement.setLong(TableColumn.FK_ACCOUNTHOLDER.index(), notificationReceiver.getAccountHolderId());
        preparedStatement.setString(TableColumn.FIRSTNAME.index(), notificationReceiver.getFirstName());
        preparedStatement.setString(TableColumn.SURNAME.index(), notificationReceiver.getSurname());
        preparedStatement.setString(TableColumn.MSISDN.index(), notificationReceiver.getMsisdn());
        preparedStatement.setString(TableColumn.EMAIL.index(), notificationReceiver.getEmailId());
        preparedStatement.setString(TableColumn.LANGUAGECODE.index(), notificationReceiver.getLanguageCode());
        return this.assignFingerprint(preparedStatement, TableColumn.FINGERPRINT.index(), new Object[]{notificationReceiver.getAccountHolderId(), notificationReceiver.getFirstName(), notificationReceiver.getSurname(), notificationReceiver.getMsisdn(), notificationReceiver.getEmailId(), notificationReceiver.getLanguageCode()});
    }

    protected NotificationReceiver createEntity(ResultSet resultSet) throws SQLException {
        return NotificationReceiver.newBuilder().id(resultSet.getLong(TableColumn.ID.name())).accountId(resultSet.getLong(TableColumn.FK_ACCOUNTHOLDER.name())).firstname(resultSet.getString(TableColumn.FIRSTNAME.name())).surname(resultSet.getString(TableColumn.SURNAME.name())).msisdn(resultSet.getString(TableColumn.MSISDN.name())).emailId(resultSet.getString(TableColumn.EMAIL.name())).languageCode(resultSet.getString(TableColumn.LANGUAGECODE.name())).build();
    }

    @Override
    public NotificationReceiver create(NotificationReceiver notificationReceiver) {
        return (NotificationReceiver)super.create((BaseEntity)notificationReceiver);
    }

    @Override
    public List<NotificationReceiver> findNotificationReceiversByAccountHolderId(long accountHolderId) {
        String statement = this.getSelectStatement() + " where fk_accountholder = ? order by id";
        return this.findMultiple(statement, new Object[]{accountHolderId});
    }

    @Override
    public NotificationReceiver findNotificationReceiver(long accountHolderId, String msisdn, String emailId) {
        StringBuilder selectQuery = new StringBuilder(200);
        selectQuery.append(this.getSelectStatement()).append(WHERE_ACCOUNTHOLDER);
        if (null != msisdn && !msisdn.isEmpty()) {
            selectQuery.append(WHERE_MSISDN);
            return (NotificationReceiver)this.find(selectQuery.toString(), new Object[]{accountHolderId, msisdn});
        }
        if (null != emailId && !emailId.isEmpty()) {
            selectQuery.append(WHERE_EMAIL);
            return (NotificationReceiver)this.find(selectQuery.toString(), new Object[]{accountHolderId, emailId});
        }
        return null;
    }

    @Override
    public void deleteNotificationReceiver(long accountHolderId, String msisdn, String emailId) {
        StringBuilder deleteQuery = new StringBuilder(100);
        deleteQuery.append("delete from ").append(TABLE_NAME).append(WHERE_ACCOUNTHOLDER);
        if (null != msisdn && !msisdn.isEmpty()) {
            deleteQuery.append(WHERE_MSISDN);
            this.delete(deleteQuery.toString(), new Object[]{accountHolderId, msisdn});
        } else if (null != emailId && !emailId.isEmpty()) {
            deleteQuery.append(WHERE_EMAIL);
            this.delete(deleteQuery.toString(), new Object[]{accountHolderId, emailId});
        }
    }

    @Override
    public NotificationReceiver update(NotificationReceiver notificationReceiver) {
        return (NotificationReceiver)super.update((BaseEntity)notificationReceiver);
    }

    private static enum TableColumn {
        ID,
        FK_ACCOUNTHOLDER,
        FIRSTNAME,
        SURNAME,
        MSISDN,
        EMAIL,
        LANGUAGECODE,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

