/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.notificationclient;

import com.ericsson.em.emc.notificationclient.NotificationChannelType;
import com.ericsson.em.emc.notificationclient.NotificationIdentity;
import java.util.Optional;

public final class DefaultNotificationIdentity
implements NotificationIdentity {
    private final String msisdn;
    private final String email;

    protected DefaultNotificationIdentity(Builder builder) {
        this.msisdn = builder.msisdn;
        this.email = builder.email;
    }

    public static DefaultNotificationIdentity fromMsisdn(String msisdn) {
        return DefaultNotificationIdentity.builder().msisdn(msisdn).build();
    }

    public static DefaultNotificationIdentity fromEmail(String email) {
        return DefaultNotificationIdentity.builder().email(email).build();
    }

    public Optional<String> getMsisdn() {
        return Optional.ofNullable(this.msisdn);
    }

    public Optional<String> getEmail() {
        return Optional.ofNullable(this.email);
    }

    @Override
    public Optional<String> getNotificationReceiverIdentity(NotificationChannelType channelType) {
        switch (channelType) {
            case EMAIL: {
                return this.getEmail();
            }
            case SMS: {
                return this.getMsisdn();
            }
        }
        return Optional.empty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.msisdn == null ? 0 : this.msisdn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNotificationIdentity other = (DefaultNotificationIdentity)obj;
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        return !(this.msisdn == null ? other.msisdn != null : !this.msisdn.equals(other.msisdn));
    }

    public static final class Builder {
        private String msisdn;
        private String email;

        public Builder msisdn(String msisdn) {
            this.msisdn = msisdn;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public DefaultNotificationIdentity build() {
            return new DefaultNotificationIdentity(this);
        }
    }
}

