/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json.converters;

import com.ericsson.em.emc.financial.CurrencyResolvedFRI;
import com.ericsson.em.emc.financial.FRI;
import com.ericsson.em.emc.util.Currency;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class FRIWithHandlerSerializer
implements JsonSerializer<FRI> {
    private static final String CURRENCY = "Currency";
    private static final String RESOLVED_FROM = "ResolvedFrom";
    private static final String TYPE = "Type";
    private static final String ID = "Id";
    private static final String HANDLER = "Handler";

    @Override
    public final JsonElement serialize(FRI src, Type srcType, JsonSerializationContext context) {
        return FRIWithHandlerSerializer.serialize(src, context);
    }

    private static JsonObject serialize(FRI src, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty(HANDLER, src.getHandler());
        object.addProperty(ID, src.getId());
        if (src instanceof CurrencyResolvedFRI) {
            CurrencyResolvedFRI currencyFRI = (CurrencyResolvedFRI)src;
            object.add(CURRENCY, context.serialize(currencyFRI.getCurrency(), (Type)((Object)Currency.class)));
        }
        if (src.getResolvedFrom() != null) {
            object.add(RESOLVED_FROM, FRIWithHandlerSerializer.serialize(src.getResolvedFrom(), context));
        }
        object.addProperty(TYPE, src.getType());
        return object;
    }
}

