/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json.converters;

import com.ericsson.em.emc.m3externallog.json.converters.Converter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeConverter
implements Converter<DateTime> {
    private final DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final DateTimeFormatter legacyFormatter = DateTimeFormat.forPattern("MMM dd, yyyy hh:mm:ss aa");

    @Override
    public DateTime deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        String text = jsonElement.getAsString();
        try {
            return this.formatter.parseDateTime(text);
        }
        catch (IllegalArgumentException x) {
            return this.legacyFormatter.parseDateTime(text);
        }
    }

    @Override
    public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(src.toString(this.formatter));
    }
}

