/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json;

import com.ericsson.em.emc.m3externallog.json.CustomExclusionStrategy;
import com.ericsson.em.emc.m3externallog.json.CustomFieldNamingStrategy;
import com.ericsson.em.emc.m3externallog.json.converters.AbstractValueObjectSerializer;
import com.ericsson.em.emc.m3externallog.json.converters.ExtensionTypeJsonSerializer;
import com.ericsson.em.emc.m3externallog.json.converters.SensitiveValue;
import com.ericsson.em.emc.m3externallog.json.converters.SensitiveValueSerializer;
import com.ericsson.em.emc.m3externallog.json.converters.Serializers;
import com.ericsson.em.emm.util.AbstractValueObject;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;

public class StaticJsonSerializer {
    private static Gson gson;
    private static Gson internalGson;
    private static final FieldNamingStrategy fieldNamingStrategy;

    public static String toJson(Object src) {
        return gson.toJson(src);
    }

    public static String toInternalJson(Object src) {
        return internalGson.toJson(src);
    }

    static {
        fieldNamingStrategy = new CustomFieldNamingStrategy();
        GsonBuilder builder = new GsonBuilder().setFieldNamingStrategy(fieldNamingStrategy);
        builder.disableHtmlEscaping();
        builder.setExclusionStrategies(new CustomExclusionStrategy());
        for (Map.Entry<Class<?>, Object> entry : Serializers.getSerializers().entrySet()) {
            builder.registerTypeAdapter(entry.getKey(), entry.getValue());
        }
        builder.registerTypeHierarchyAdapter(SensitiveValue.class, new SensitiveValueSerializer());
        builder.registerTypeHierarchyAdapter(AbstractValueObject.class, new AbstractValueObjectSerializer());
        builder.registerTypeHierarchyAdapter(ExtensionType.class, new ExtensionTypeJsonSerializer());
        gson = builder.create();
        GsonBuilder internalBuilder = new GsonBuilder().setFieldNamingStrategy(fieldNamingStrategy);
        internalBuilder.setExclusionStrategies(new CustomExclusionStrategy());
        for (Map.Entry<Class<?>, Object> entry : Serializers.getInternalSerializers().entrySet()) {
            internalBuilder.registerTypeAdapter(entry.getKey(), entry.getValue());
        }
        internalBuilder.registerTypeHierarchyAdapter(SensitiveValue.class, new SensitiveValueSerializer());
        internalBuilder.registerTypeHierarchyAdapter(AbstractValueObject.class, new AbstractValueObjectSerializer());
        internalBuilder.registerTypeHierarchyAdapter(ExtensionType.class, new ExtensionTypeJsonSerializer());
        internalGson = internalBuilder.create();
    }
}

