/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class ObjectDeserializer
implements JsonDeserializer<Object> {
    @Override
    public Object deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull()) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
        } else {
            if (json.isJsonArray()) {
                JsonArray array = json.getAsJsonArray();
                ArrayList<Object> result = new ArrayList<Object>();
                for (JsonElement element : array) {
                    result.add(this.deserialize(element, null, context));
                }
                return result;
            }
            if (json.isJsonObject()) {
                JsonObject object = json.getAsJsonObject();
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
                    Object value = this.deserialize(entry.getValue(), null, context);
                    result.put(entry.getKey(), value);
                }
                return result;
            }
            throw new JsonParseException("Unknown JSON type for JsonElement " + json.toString());
        }
        return null;
    }
}

