/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json;

import com.google.gson.FieldNamingStrategy;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomFieldNamingStrategy
implements FieldNamingStrategy {
    private static final Pattern prefixPattern = Pattern.compile("^m([\\p{Lu}0-9].*)");

    @Override
    public String translateName(Field field) {
        Class<?> clazz = field.getDeclaringClass();
        String name = field.getName();
        if (clazz.getName().startsWith("com.ericsson")) {
            Matcher matcher = prefixPattern.matcher(name);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return name.substring(0, 1).toUpperCase() + (name.length() > 1 ? name.substring(1) : "");
        }
        return name;
    }
}

