/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.provisioning;

import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.limits.LegacyLimitsConverter;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.GlobalParameter;
import com.ericsson.em.emc.hierarchies.persistence.GlobalParameterDAO;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationManager;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.Periodizable;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDefaultDataDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDefaultSettingsHelper;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.ericsson.em.emc.hierarchies.persistence.Property;
import com.ericsson.em.emc.hierarchies.persistence.PropertyDAO;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfigurationDAO;
import com.ericsson.em.emc.hierarchies.provisioning.BaseProvisioningManager;
import com.ericsson.em.emc.hierarchies.provisioning.ProvisioningResult;
import com.ericsson.em.emc.hierarchies.provisioning.ProvisioningSettings;
import com.ericsson.em.emc.util.XmlFactory;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.security.AccessController;
import com.ericsson.lwac.transaction.TransactionManager;
import com.ericsson.lwac.transaction.UnstartedTransaction;
import com.ericsson.lwac.utilities.XmlUtils;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class BaseProvisioningManagerBean
implements BaseProvisioningManager {
    private static final String TAG_CONFIG = "config";
    private static final String ATTR_SERVICE = "service";
    private static final String ATTR_STATUS = "status";
    private static final String ATTR_STATUS_UPDATE = "update";
    private static final String TAG_CREATE_CHILD_SERVICE = "create-child-services";
    private static final String TAG_REMOVE_CHILD_SERVICE = "remove-child-services";
    private static final String ATTR_PROFILENAME = "profilename";
    private static final Logger logger = LoggerFactory.getLogger(BaseProvisioningManagerBean.class);
    private static final String TAG_SERVICE = "service";
    @EJB
    private ProfileDAO profileDAO;
    @EJB
    private ProfileDefaultDataDAO profileDefaultDataDAO;
    @EJB
    private ProfileServiceDAO serviceDAO;
    @EJB
    private ThresholdConfigurationDAO thresholdConfigurationDAO;
    @EJB
    private IndividualCounterConfigurationManager individualCounterConfigurationManager;
    @EJB
    private ModifierConfigurationDAO modifierConfigurationDAO;
    @EJB
    private PropertyDAO propertyDAO;
    @EJB
    private GlobalParameterDAO globalParameterDAO;
    @EJB
    private ProfileDefaultSettingsHelper profileDefaultSettingsHelper;
    @Resource
    private TransactionManager transactionHelper;
    @Resource
    private AccessController accessController;

    private void describeAndLogInfo(List<String> description, String message) {
        description.add(message);
        logger.info(message);
    }

    @Override
    public ProvisioningResult create(Element configRoot, ProvisioningSettings settings) {
        ProvisioningResult description = new ProvisioningResult();
        this.checkRootTagNodeName(configRoot);
        description.addAll(this.transactionHelper.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), () -> this.createProfiles(configRoot)));
        description.addAll(this.transactionHelper.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), () -> this.createGlobalParameters(configRoot)));
        description.addAll(this.transactionHelper.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), () -> this.createOthers(configRoot, settings)));
        for (Element commandElement : XmlUtils.getChildElementList(configRoot)) {
            String currentNodeName = commandElement.getNodeName();
            if (TAG_REMOVE_CHILD_SERVICE.equals(currentNodeName)) {
                description.addAll(this.transactionHelper.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), () -> this.removeServices(commandElement)));
                continue;
            }
            if (!TAG_CREATE_CHILD_SERVICE.equals(currentNodeName)) continue;
            description.addAll(this.transactionHelper.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), () -> this.createServices(commandElement)));
        }
        return description;
    }

    @Override
    public ProvisioningResult create(String path, ProvisioningSettings settings) throws Exception {
        return this.accessController.doPrivilegedAction(() -> {
            DocumentBuilderFactory domFactory = XmlFactory.newDocumentBuilderFactory();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document document = builder.parse(ClassLoader.getSystemClassLoader().getResourceAsStream(path));
            return this.create(document.getDocumentElement(), settings);
        });
    }

    @Override
    public ProvisioningResult createWithoutProfileAndService(String path, ProvisioningSettings settings) throws Exception {
        return this.accessController.doPrivilegedAction(() -> {
            DocumentBuilderFactory domFactory = XmlFactory.newDocumentBuilderFactory();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document document = builder.parse(ClassLoader.getSystemClassLoader().getResourceAsStream(path));
            return this.createWithoutProfileAndService(document.getDocumentElement(), settings);
        });
    }

    private ProvisioningResult createWithoutProfileAndService(Element configRoot, ProvisioningSettings settings) {
        ProvisioningResult description = new ProvisioningResult();
        this.checkRootTagNodeName(configRoot);
        description.addAll(this.transactionHelper.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), () -> this.createGlobalParameters(configRoot)));
        description.addAll(this.transactionHelper.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), () -> this.createOthers(configRoot, settings)));
        return description;
    }

    private void checkRootTagNodeName(Element configRoot) {
        if (!TAG_CONFIG.equals(configRoot.getNodeName())) {
            throw new IllegalArgumentException("faulty xml structure must begin with node name config");
        }
    }

    private void checkAttribute(String attributeName, Element element) {
        if (!element.hasAttribute(attributeName)) {
            throw new IllegalArgumentException("Missing attribute " + attributeName + " for " + element.getNodeName());
        }
    }

    private boolean hasStatusUpdate(Element element) {
        return element.hasAttribute(ATTR_STATUS) && element.getAttribute(ATTR_STATUS).equals(ATTR_STATUS_UPDATE);
    }

    private ProfileService getParentService(String profileName, String parentServiceName) {
        Profile profile = this.profileDAO.findByName(profileName);
        if (profile == null) {
            throw new IllegalArgumentException("Profile '" + profileName + "' NOT found");
        }
        ProfileService parentService = this.getService(profile, parentServiceName);
        if (parentService == null) {
            throw new IllegalArgumentException("Service '" + parentServiceName + "' NOT found in profile '" + profileName + "'");
        }
        return parentService;
    }

    protected List<String> createServices(Element createServiceElement) {
        LinkedList<String> description = new LinkedList<String>();
        this.checkAttribute(ATTR_PROFILENAME, createServiceElement);
        this.checkAttribute("service", createServiceElement);
        String profileName = createServiceElement.getAttribute(ATTR_PROFILENAME);
        String serviceName = createServiceElement.getAttribute("service");
        ProfileService parentService = this.getParentService(profileName, serviceName);
        for (Element childServiceElement : XmlUtils.getChildElementListByName("service", createServiceElement)) {
            this.createChildService(parentService, childServiceElement);
            description.add("Added service '" + childServiceElement.getAttribute("name") + "' to profile " + profileName + "/" + parentService.getName());
        }
        return description;
    }

    protected List<String> removeServices(Element removeServicesElement) {
        LinkedList<String> description = new LinkedList<String>();
        this.checkAttribute(ATTR_PROFILENAME, removeServicesElement);
        this.checkAttribute("service", removeServicesElement);
        String profileName = removeServicesElement.getAttribute(ATTR_PROFILENAME);
        String parentServiceName = removeServicesElement.getAttribute("service");
        ProfileService parentService = this.getParentService(profileName, parentServiceName);
        block0: for (Element childServiceElement : XmlUtils.getChildElementListByName("service", removeServicesElement)) {
            String serviceNameToRemove = childServiceElement.getAttribute("name");
            for (ProfileService currentProfileService : parentService.getChildren()) {
                if (!serviceNameToRemove.equals(currentProfileService.getName())) continue;
                this.serviceDAO.delete(currentProfileService);
                this.describeAndLogInfo(description, "Deleted service '" + serviceNameToRemove + "' from profile " + profileName + "/" + parentService.getName());
                continue block0;
            }
        }
        return description;
    }

    private ProfileService getService(Profile profile, String wantedServiceName) {
        ProfileService wantedProfileService = null;
        List<ProfileService> services = profile.getServices();
        for (ProfileService profileService : services) {
            if (!wantedServiceName.equals(profileService.getName())) continue;
            wantedProfileService = profileService;
            break;
        }
        return wantedProfileService;
    }

    protected List<String> createOthers(Element configRoot, ProvisioningSettings settings) {
        return new LinkedList<String>();
    }

    private List<String> createGlobalParameters(Element configRoot) {
        LinkedList<String> result = new LinkedList<String>();
        if (!TAG_CONFIG.equals(configRoot.getNodeName())) {
            throw new IllegalArgumentException();
        }
        for (Element custodyAccountElement : XmlUtils.getChildElementListByName("globalparameter", configRoot)) {
            result.add(this.createGlobalParameter(custodyAccountElement));
        }
        return result;
    }

    private String createGlobalParameter(Element globalParameterElement) {
        if (!"globalparameter".equals(globalParameterElement.getNodeName())) {
            throw new IllegalArgumentException();
        }
        List<Element> propertyList = XmlUtils.getChildElementList(globalParameterElement);
        if (this.globalParameterDAO.findByKey(this.getPropertyValue("key", propertyList)) == null) {
            GlobalParameter globalParameter = new GlobalParameter();
            this.setId(globalParameter, globalParameterElement);
            globalParameter.setKey(this.getPropertyValue("key", propertyList));
            globalParameter.setValue(this.getPropertyValue("value", propertyList));
            globalParameter.setDataType(this.getPropertyValue("datatype", propertyList));
            this.globalParameterDAO.create(globalParameter);
            return this.getPropertyValue("key", propertyList);
        }
        return null;
    }

    private ProvisioningResult createProfiles(Element profileRoot) {
        ProvisioningResult description = new ProvisioningResult();
        if (!TAG_CONFIG.equals(profileRoot.getNodeName())) {
            throw new IllegalArgumentException();
        }
        for (Element profileElement : XmlUtils.getChildElementListByName("profile", profileRoot)) {
            description.addAll(this.createProfile(profileElement));
        }
        return description;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<String> createProfile(Element profileElement) {
        LinkedList<String> description = new LinkedList<String>();
        if ("profile".equals(profileElement.getNodeName())) {
            String name = profileElement.getAttribute("name");
            Profile profile = new Profile(name);
            this.setId(profile, profileElement);
            if (profileElement.hasAttribute("id")) {
                Profile existedProfile = this.profileDAO.find(profile.getId());
                Profile profile2 = existedProfile = existedProfile == null ? this.profileDAO.findByName(profile.getName()) : existedProfile;
                if (existedProfile != null) {
                    this.describeAndLogInfo(description, String.format("Profile %s (%d) already exists", profile.getName(), profile.getId()));
                    this.profileDefaultSettingsHelper.createOrUpdateAuthorizationService(existedProfile);
                    return null;
                }
                profile = this.profileDefaultDataDAO.create(profile);
                this.describeAndLogInfo(description, String.format("Profile %s (%d) created", profile.getName(), profile.getId()));
            } else if (this.hasStatusUpdate(profileElement)) {
                profile = this.profileDAO.findByName(name);
                if (profile == null) {
                    this.describeAndLogInfo(description, String.format("Profile %s is not found", name));
                    return description;
                }
            } else {
                profile = this.profileDAO.create(profile);
            }
            for (Element child : XmlUtils.getChildElementList(profileElement)) {
                if (!"service".equals(child.getNodeName())) continue;
                profile = this.createService(profile, child).getProfile();
            }
            this.profileDefaultSettingsHelper.createOrUpdateAuthorizationService(profile);
        }
        return description;
    }

    private ProfileService createService(Profile profile, Element serviceElement) {
        if ("service".equals(serviceElement.getNodeName())) {
            ProfileService profileService;
            String name = serviceElement.getAttribute("name");
            if (this.hasStatusUpdate(serviceElement)) {
                profileService = this.serviceDAO.findByName(name, profile);
            } else {
                profileService = new ProfileService();
                profileService.setName(name);
                List<Element> propertyList = XmlUtils.getChildElementList(serviceElement);
                this.setPeriodType(profileService, this.getPropertyValueAsInt("PERIODTYPE", propertyList));
                profileService.setBalanceReuseable(this.getPropertyValueAsBoolean("BALANCEREUSABLE", propertyList));
                profileService.setPeriodLength(this.getPropertyValueAsInt("PERIODLENGTH", propertyList));
                profileService.setStartDayInMonth(this.getPropertyValueAsInt("STARTDAYINMONTH", propertyList));
                profileService = this.serviceDAO.create(profileService, profile);
            }
            for (Element child : XmlUtils.getChildElementList(serviceElement)) {
                ProfileService childService;
                Property createProperty;
                CounterConfiguration createCounterConfiguration;
                ThresholdConfiguration createThreshold;
                if ("threshold".equals(child.getNodeName()) && (createThreshold = this.createThreshold(profileService, child)) != null && createThreshold.getService() != null) {
                    profileService = createThreshold.getService();
                }
                if ("counter.configuration".equals(child.getNodeName()) && (createCounterConfiguration = this.createCounterConfiguration(profileService, child)) != null && ((IndividualCounterConfiguration)createCounterConfiguration).getService() != null) {
                    profileService = ((IndividualCounterConfiguration)createCounterConfiguration).getService();
                }
                if ("property.configuration".equals(child.getNodeName()) && (createProperty = this.createProperty(profileService, child)) != null && createProperty.getService() != null) {
                    profileService = createProperty.getService();
                }
                if (!"service".equals(child.getNodeName()) || (childService = this.createChildService(profileService, child)) == null || childService.getParent() == null) continue;
                profileService = childService.getParent();
            }
            return profileService;
        }
        return null;
    }

    private ThresholdConfiguration createThreshold(ProfileService profileService, Element thresholdElement) {
        if ("threshold".equals(thresholdElement.getNodeName())) {
            ThresholdConfiguration thresholdConfiguration = new ThresholdConfiguration();
            thresholdConfiguration.setName(thresholdElement.getAttribute("name"));
            List<Element> propertyList = XmlUtils.getChildElementList(thresholdElement);
            thresholdConfiguration.setThreshold(new BigDecimal(this.getPropertyValue("THRESHOLD", propertyList)));
            thresholdConfiguration.setThresholdType(this.getPropertyValue("UNITTYPE", propertyList));
            thresholdConfiguration.setClassName(this.getPropertyValue("CLASSNAME", propertyList));
            thresholdConfiguration.setData(this.getPropertyValue("DATA", propertyList));
            thresholdConfiguration.setUnit(Unit.fromString(this.getPropertyValue("UNIT", propertyList)));
            return this.thresholdConfigurationDAO.create(thresholdConfiguration, profileService);
        }
        return null;
    }

    private CounterConfiguration createCounterConfiguration(ProfileService profileService, Element counterConfigurationElement) {
        if ("counter.configuration".equals(counterConfigurationElement.getNodeName())) {
            CounterConfiguration counterConfiguration = new IndividualCounterConfiguration();
            List<Element> propertyList = XmlUtils.getChildElementList(counterConfigurationElement);
            counterConfiguration.setName(counterConfigurationElement.getAttribute("name"));
            counterConfiguration.setBalanceReuseable(this.getPropertyValueAsBoolean("BALANCEREUSABLE", propertyList));
            this.setPeriodType(counterConfiguration, this.getPropertyValueAsInt("PERIODTYPE", propertyList));
            counterConfiguration.setPeriodLength(this.getPropertyValueAsInt("PERIODLENGTH", propertyList));
            counterConfiguration.setStartDayInMonth(this.getPropertyValueAsInt("STARTDAYINMONTH", propertyList));
            counterConfiguration.setExternalId(this.getPropertyValue("EXTERNALID", propertyList));
            counterConfiguration.setCounterType(LegacyLimitsConverter.extractCounterTypeFrom(this.getPropertyValue("UNITTYPE", propertyList)));
            counterConfiguration.setMatchRules(LegacyLimitsConverter.convertToCounterMatchRules(this.getPropertyValue("UNITTYPE", propertyList)));
            counterConfiguration.setDynamicType(this.getDynamicType(this.getPropertyValueAsInt("DYNAMICTYPE", propertyList)));
            counterConfiguration.setDynamicLength(this.getPropertyValueAsInt("DYNAMICLENGTH", propertyList));
            counterConfiguration.setUnit(Unit.fromString(this.getPropertyValue("UNIT", propertyList)));
            counterConfiguration.setPersonalizedLimitAllowed(this.getPropertyValueAsBoolean("PERSONALIZEDLIMITALLOWED", propertyList));
            counterConfiguration = this.individualCounterConfigurationManager.create((IndividualCounterConfiguration)counterConfiguration, profileService);
            for (Element child : XmlUtils.getChildElementList(counterConfigurationElement)) {
                ModifierConfiguration createdModifierConfiguration;
                if (!"modifier".equals(child.getNodeName()) || (createdModifierConfiguration = this.createModifierConfiguration(counterConfiguration, child)) == null || createdModifierConfiguration.getCounterConfiguration() == null) continue;
                counterConfiguration = createdModifierConfiguration.getCounterConfiguration();
            }
            return counterConfiguration;
        }
        return null;
    }

    private ModifierConfiguration createModifierConfiguration(CounterConfiguration counterConfiguration, Element modifierConfigurationElement) {
        if ("modifier".equals(modifierConfigurationElement.getNodeName())) {
            List<Element> propertyList = XmlUtils.getChildElementList(modifierConfigurationElement);
            ModifierConfiguration modifierConfiguration = new ModifierConfiguration();
            modifierConfiguration.setStartValue(this.getPropertyValueAsBigDecimal("STARTVALUE", propertyList));
            modifierConfiguration.setEndValue(this.getPropertyValueAsBigDecimal("ENDVALUE", propertyList));
            modifierConfiguration.setClassName(this.getPropertyValue("CLASSNAME", propertyList));
            modifierConfiguration.setData(this.getPropertyValue("DATA", propertyList));
            return this.modifierConfigurationDAO.create(modifierConfiguration, counterConfiguration);
        }
        return null;
    }

    private Property createProperty(ProfileService profileService, Element propertyElement) {
        if ("property.configuration".equals(propertyElement.getNodeName())) {
            List<Element> propertyList = XmlUtils.getChildElementList(propertyElement);
            Property property = new Property();
            property.setName(this.getPropertyValue("NAME", propertyList));
            property.setValue(this.getPropertyValue("VALUE", propertyList));
            return this.propertyDAO.create(property, profileService);
        }
        return null;
    }

    private ProfileService createChildService(ProfileService parentService, Element childServiceElement) {
        if ("service".equals(childServiceElement.getNodeName())) {
            ProfileService profileService = new ProfileService();
            profileService.setName(childServiceElement.getAttribute("name"));
            profileService = this.serviceDAO.create(profileService, parentService);
            for (Element child : XmlUtils.getChildElementList(childServiceElement)) {
                ProfileService createChildService;
                Property createProperty;
                CounterConfiguration createCounterConfiguration;
                ThresholdConfiguration createThreshold;
                if ("threshold".equals(child.getNodeName()) && (createThreshold = this.createThreshold(profileService, child)) != null && createThreshold.getService() != null) {
                    profileService = createThreshold.getService();
                }
                if ("counter.configuration".equals(child.getNodeName()) && (createCounterConfiguration = this.createCounterConfiguration(profileService, child)) != null && ((IndividualCounterConfiguration)createCounterConfiguration).getService() != null) {
                    profileService = ((IndividualCounterConfiguration)createCounterConfiguration).getService();
                }
                if ("property.configuration".equals(child.getNodeName()) && (createProperty = this.createProperty(profileService, child)) != null && createProperty.getService() != null) {
                    profileService = createProperty.getService();
                }
                if (!"service".equals(child.getNodeName()) || (createChildService = this.createChildService(profileService, child)) == null || createChildService.getParent() == null) continue;
                profileService = createChildService.getParent();
            }
            return profileService;
        }
        return null;
    }

    protected String getPropertyValue(String propertyName, List<Element> propertyElementList) {
        for (Element property : propertyElementList) {
            if (!"property".equals(property.getNodeName()) || !propertyName.equals(property.getAttribute("name"))) continue;
            return property.getAttribute("value");
        }
        return null;
    }

    protected boolean hasPropertyValue(String propertyName, List<Element> propertyElementList) {
        for (Element property : propertyElementList) {
            if (!"property".equals(property.getNodeName()) || !propertyName.equals(property.getAttribute("name"))) continue;
            return true;
        }
        return false;
    }

    private int getPropertyValueAsInt(String propertyName, List<Element> propertyElementList) {
        return Integer.parseInt(this.getPropertyValue(propertyName, propertyElementList));
    }

    private boolean getPropertyValueAsBoolean(String propertyName, List<Element> propertyElementList) {
        String boolStr = this.getPropertyValue(propertyName, propertyElementList);
        if ("Y".equals(boolStr)) {
            return true;
        }
        return Boolean.valueOf(boolStr);
    }

    private BigDecimal getPropertyValueAsBigDecimal(String propertyName, List<Element> propertyElementList) {
        return new BigDecimal(this.getPropertyValue(propertyName, propertyElementList));
    }

    protected void setId(BaseEntity entity, Element config) {
        try {
            if (config.hasAttribute("id")) {
                BaseEntity.class.getDeclaredMethods();
                Method method = BaseEntity.class.getDeclaredMethod("setId", Long.class);
                method.setAccessible(true);
                method.invoke((Object)entity, Long.parseLong(config.getAttribute("id")));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No method for setting id " + e.getMessage());
        }
    }

    private void setPeriodType(Periodizable periodizable, int ordinal) {
        for (Periodizable.PeriodType periodType : Periodizable.PeriodType.values()) {
            if (periodType.ordinal() != ordinal) continue;
            periodizable.setPeriodType(periodType);
            return;
        }
        throw new IllegalArgumentException("ordinal " + ordinal + " is NOT valid for PeriodType");
    }

    private CounterConfiguration.DynamicType getDynamicType(int ordinal) {
        for (CounterConfiguration.DynamicType dynType : CounterConfiguration.DynamicType.values()) {
            if (dynType.ordinal() != ordinal) continue;
            return dynType;
        }
        throw new IllegalArgumentException("ordinal " + ordinal + " is NOT valid for DynamicType");
    }
}

