/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.ericsson.em.emc.hierarchies.persistence.Property;
import com.ericsson.em.emc.hierarchies.persistence.PropertyDAO;
import com.ericsson.em.emc.hierarchies.persistence.PropertyFPDAOBean;
import com.ericsson.em.emc.hierarchies.persistence.PropertyListener;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;

@Singleton
@Updatable
@Validatable
@CryptoKeys(keyAliases={"hier.properties.S"})
public class PropertyDAOBean
extends CryptoExtendedBaseEntityDAOBean<Property>
implements PropertyDAO {
    @EJB
    private ProfileServiceDAO serviceDAO;
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    static final String FINGERPRINT_KEY = "hier.properties.S";
    static final String DB_TABLENAME = "hier$properties";
    private final List<PropertyListener> propertyListeners = new CopyOnWriteArrayList<PropertyListener>();

    protected Property createManagedEntity() {
        return new Property();
    }

    @Override
    public Property create(Property property, ProfileService profileService) {
        property.setService(profileService);
        for (Property currentProperty : profileService.getProperties()) {
            if (!currentProperty.getName().equals(property.getName())) continue;
            throw new IllegalArgumentException("Property '" + property.getName() + "' already exists on service '" + profileService.getName() + "'");
        }
        super.create((BaseEntity)property);
        LinkedList<Property> properties = new LinkedList<Property>(profileService.getProperties());
        if (properties.contains(property)) {
            return property;
        }
        properties.add(property);
        profileService.setProperties(Collections.unmodifiableList(properties));
        this.serviceDAO.update(profileService);
        this.propertyListeners.forEach(listener -> listener.onPropertyCreated(property));
        return property;
    }

    @Override
    public Property update(Property property) {
        Property updated = (Property)super.update((BaseEntity)property);
        this.serviceDAO.update(property.getService());
        this.propertyListeners.forEach(listener -> listener.onPropertyUpdated(updated));
        return updated;
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        Property property = (Property)baseEntity;
        int i = 1;
        preparedStatement.setLong(i++, property.getService().getId());
        preparedStatement.setString(i++, property.getName());
        preparedStatement.setString(i++, property.getValue());
        return this.assignFingerprint(preparedStatement, i, new Object[]{property.getService().getId(), property.getName(), property.getValue()});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        Property property = (Property)baseEntity;
        property.setName(resultSet.getString(TableColumn.NAME.name()));
        property.setValue(resultSet.getString(TableColumn.PVALUE.name()));
    }

    @Override
    public List<Property> findByService(ProfileService profileService) {
        List properties = this.findMultiple(this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.FK_SERVICE) + " = ?", new Object[]{profileService.getId()});
        for (Property property : properties) {
            property.setService(profileService);
        }
        return properties;
    }

    @Override
    public void delete(Property aProperty) {
        super.delete((BaseEntity)aProperty);
        ProfileService service = aProperty.getService();
        LinkedList<Property> properties = new LinkedList<Property>(service.getProperties());
        properties.remove(aProperty);
        service.setProperties(Collections.unmodifiableList(properties));
        this.serviceDAO.update(service);
        this.propertyListeners.forEach(listener -> listener.onPropertyDeleted(aProperty));
    }

    @Override
    public void deleteByService(ProfileService profileService) {
        List<Property> profiles = this.findByService(profileService);
        for (Property property : profiles) {
            super.delete((BaseEntity)property);
            this.propertyListeners.forEach(listener -> listener.onPropertyDeleted(property));
        }
    }

    @Override
    public Map<Long, List<Property>> findAllProperties(Profile profile) {
        HashMap<Long, List<Property>> allProperties = new HashMap<Long, List<Property>>();
        Map<ProfileService, Long> allServices = this.serviceDAO.findAllServices(profile);
        ArrayList allServiceIds = new ArrayList();
        allServices.forEach((service, parentServiceId) -> allServiceIds.add(service.getId()));
        allServiceIds.stream().forEach(id -> {
            List properties = this.findMultiple(this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.FK_SERVICE) + " = ?", new Object[]{id});
            if (!properties.isEmpty()) {
                allProperties.put((Long)id, properties);
            }
        });
        return allProperties;
    }

    @Override
    public void registerListener(PropertyListener propertyListener) {
        this.propertyListeners.add(propertyListener);
    }

    protected String getEntitySimpleName() {
        return Property.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getLong(TableColumn.FK_SERVICE.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getString(TableColumn.PVALUE.name())};
        }
        return null;
    }

    public String[] getColumns() {
        return (String[])Stream.of(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return DB_TABLENAME;
    }

    public String getSequenceName() {
        return "hier$properties_seq";
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    public Class<? extends CryptoExtendedBaseEntityDAOBean> getDaoBeanForUpdateFpCli() {
        return PropertyFPDAOBean.class;
    }

    private static enum TableColumn {
        ID,
        FK_SERVICE,
        NAME,
        PVALUE,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

