/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationManager;
import com.ericsson.em.emc.hierarchies.persistence.PeriodizableManagerBean;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileCounterRelation;
import com.ericsson.em.emc.hierarchies.persistence.ProfileCounterRelationDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceFPDAOBean;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceListener;
import com.ericsson.em.emc.hierarchies.persistence.Property;
import com.ericsson.em.emc.hierarchies.persistence.PropertyDAO;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterOverride;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfigurationDAO;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.monitoring.Measurement;
import com.ericsson.lwac.monitoring.StatisticsService;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.joda.time.DateTime;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"hier.service.S"})
public class ProfileServiceDAOBean
extends PeriodizableManagerBean<ProfileService>
implements ProfileServiceDAO {
    static final String FINGERPRINT_KEY = "hier.service.S";
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final String TABLE_NAME = "hier$service";
    private static final String TABLE_SEQUENCE_NAME = "hier$service_seq";
    @EJB
    private IndividualCounterConfigurationManager individualCounterConfigurationManager;
    @EJB
    private SharedCounterConfigurationDAO sharedCounterConfigurationDAO;
    @EJB
    private ProfileCounterRelationDAO profileCounterRelationDAO;
    @EJB
    private PropertyDAO propertyDAO;
    @EJB
    private ThresholdConfigurationDAO thresholdDAO;
    @EJB
    private ProfileDAO profileDAO;
    @Resource
    private ApplicationContext applicationContext;
    private final List<ProfileServiceListener> profileServiceListeners = new CopyOnWriteArrayList<ProfileServiceListener>();

    @Override
    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        ProfileService profileService = (ProfileService)baseEntity;
        int i = super.assign((BaseEntity)profileService, preparedStatement);
        preparedStatement.setString(i++, profileService.getName());
        preparedStatement.setLong(i++, profileService.getProfile().getId());
        if (profileService.getParent() == null) {
            preparedStatement.setNull(i++, -5);
        } else {
            preparedStatement.setLong(i++, profileService.getParent().getId());
        }
        return this.assignFingerprint(preparedStatement, i, new Object[]{ProfileServiceDAOBean.getTimestamp((DateTime)profileService.getStartDateTime()), ProfileServiceDAOBean.getTimestamp((DateTime)profileService.getEndDateTime()), profileService.getPeriodType().ordinal(), profileService.isBalanceReuseable() ? "Y" : "N", profileService.getPeriodLength(), profileService.getStartDayInMonth(), profileService.getName(), profileService.getProfile().getId(), profileService.getParent() != null ? profileService.getParent().getId() : null});
    }

    @Override
    public ProfileService update(ProfileService profileService) {
        ProfileService updated = (ProfileService)super.update((BaseEntity)profileService);
        this.profileDAO.update(profileService.getProfile());
        this.profileServiceListeners.forEach(listener -> listener.onProfileServiceUpdated(updated));
        return updated;
    }

    @Override
    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        ProfileService profileService = (ProfileService)baseEntity;
        profileService.setName(resultSet.getString("name"));
        profileService.setChildren(this.findChildren(profileService));
        profileService.setIndividualCounterConfigurations(this.individualCounterConfigurationManager.findByService(profileService));
        List<ProfileCounterRelation> profileCounterRelations = this.profileCounterRelationDAO.findRelationByProfileService(profileService.getId());
        ArrayList<SharedCounterConfiguration> sharedCounterConfigurations = new ArrayList<SharedCounterConfiguration>();
        for (ProfileCounterRelation counterRelation : profileCounterRelations) {
            sharedCounterConfigurations.add(this.sharedCounterConfigurationDAO.findByName(counterRelation.getCounterConfigurationName()));
        }
        profileService.setSharedCounterConfigurations(sharedCounterConfigurations);
        ArrayList<SharedCounterOverride> sharedCounterOverrides = new ArrayList<SharedCounterOverride>();
        profileCounterRelations.forEach(relation -> sharedCounterOverrides.add(SharedCounterOverride.newBuilder().name(relation.getCounterConfigurationName()).limit(relation.getCounterConfigurationLimit()).build()));
        profileService.setSharedCounterOverrides(sharedCounterOverrides);
        profileService.setProperties(this.propertyDAO.findByService(profileService));
        profileService.setThresholdConfigurations(this.thresholdDAO.findByService(profileService));
    }

    @Override
    public ProfileService findByName(String name, Profile profile) {
        ProfileService result = null;
        for (ProfileService profileService : profile.getServices()) {
            result = this.findService(profileService, name);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private List<ProfileService> findChildren(ProfileService parentService) {
        List children = this.findMultiple(this.getSelectStatement() + " where fk_parentservice = ?", new Object[]{parentService.getId()});
        for (ProfileService child : children) {
            child.setParent(parentService);
        }
        return children;
    }

    protected ProfileService createManagedEntity() {
        return new ProfileService();
    }

    @Override
    public ProfileService create(ProfileService profileService, Profile profile) {
        if (profile == null || profile.getId() == 0L) {
            throw new IllegalArgumentException("Profile must be persisted before creating service type");
        }
        LinkedList<ProfileService> profileServices = new LinkedList<ProfileService>(profile.getServices());
        if (profileServices.contains(profileService)) {
            throw new IllegalArgumentException("ProfileService type already added to profile");
        }
        if (this.findByName(profileService.getName(), profile) != null) {
            throw new IllegalArgumentException(String.format("ProfileService with name \"%s\" already exists for profile %s", profileService.getName(), profile.getName()));
        }
        profileService.setProfile(profile);
        profileServices.add(profileService);
        profile.setServices(Collections.unmodifiableList(profileServices));
        super.create((BaseEntity)profileService);
        this.profileDAO.update(profile);
        this.profileServiceListeners.forEach(listener -> listener.onProfileServiceCreated(profileService));
        return profileService;
    }

    @Override
    public void delete(ProfileService aService) {
        for (ProfileService profileService : aService.getChildren()) {
            this.delete(profileService);
        }
        for (CounterConfiguration counterConfiguration : new LinkedList<IndividualCounterConfiguration>(aService.getIndividualCounterConfigurations())) {
            this.individualCounterConfigurationManager.delete((IndividualCounterConfiguration)counterConfiguration);
        }
        for (Property property : new LinkedList<Property>(aService.getProperties())) {
            this.propertyDAO.delete(property);
        }
        for (ThresholdConfiguration thresholdConfiguration : new LinkedList<ThresholdConfiguration>(aService.getThresholdConfigurations())) {
            this.thresholdDAO.delete(thresholdConfiguration);
        }
        super.delete((BaseEntity)aService);
        ProfileService parent = aService.getParent();
        LinkedList<ProfileService> linkedList = new LinkedList<ProfileService>(parent.getChildren());
        linkedList.remove(aService);
        parent.setChildren(Collections.unmodifiableList(linkedList));
        this.update(parent);
        this.profileServiceListeners.forEach(listener -> listener.onProfileServiceDeleted(aService));
    }

    @Override
    public Map<ProfileService, Long> findAllServices(Profile profile) {
        HashMap<ProfileService, Long> allServices = new HashMap<ProfileService, Long>();
        String statement = this.getSelectStatement() + " where fk_profile = ?";
        Measurement measurement = this.statisticsService.startMeasurment("sql", statement, StatisticsService.MeasurementType.OUTGOING);
        try (Connection connection = this.dataSource.getReadOnlyConnection(this.getPreferredConnectionType());
             PreparedStatement preparedStatement = connection.prepareStatement(statement);){
            preparedStatement.setLong(1, profile.getId());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    ProfileService profileService = new ProfileService();
                    super.assign((BaseEntity)profileService, resultSet);
                    this.validate(profileService, resultSet);
                    profileService.setName(resultSet.getString("name"));
                    profileService.setProfile(profile);
                    allServices.put(profileService, resultSet.getObject("fk_parentService") != null ? Long.valueOf(resultSet.getLong("fk_parentService")) : null);
                }
            }
        }
        catch (SQLException e) {
            measurement.setError();
            throw new PersistenceException(String.format("Error while executing: %s parameters %s", statement, profile.getId()), e);
        }
        finally {
            this.statisticsService.stopMeasurement(measurement);
        }
        return allServices;
    }

    @Override
    public ProfileService create(ProfileService profileService, ProfileService parentService) {
        if (parentService == null || parentService.getId() == 0L) {
            throw new IllegalArgumentException("Parent service type must be persisted before creating service type");
        }
        LinkedList<ProfileService> profileServices = new LinkedList<ProfileService>(parentService.getChildren());
        if (profileServices.contains(profileService)) {
            throw new IllegalArgumentException("ProfileService type already child to profile");
        }
        if (parentService.getChildByName(profileService.getName()) != null) {
            throw new IllegalArgumentException(String.format("ProfileService with name \"%s\" already exists", profileService.getName()));
        }
        profileService.setParent(parentService);
        profileService.setProfile(parentService.getProfile());
        profileServices.add(profileService);
        parentService.setChildren(Collections.unmodifiableList(profileServices));
        super.create((BaseEntity)profileService);
        this.profileDAO.update(parentService.getProfile());
        this.profileServiceListeners.forEach(listener -> listener.onProfileServiceCreated(profileService));
        return profileService;
    }

    @Override
    public ProfileService findService(Profile profile, long id) {
        ProfileService result = null;
        for (ProfileService profileService : profile.getServices()) {
            result = this.findService(profileService, id);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private ProfileService findService(ProfileService profileService, long id) {
        if (profileService.getId() == id) {
            return profileService;
        }
        for (ProfileService childService : profileService.getChildren()) {
            ProfileService result = this.findService(childService, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private ProfileService findService(ProfileService profileService, String name) {
        if (profileService.getName().equals(name)) {
            return profileService;
        }
        for (ProfileService childService : profileService.getChildren()) {
            ProfileService result = this.findService(childService, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void deleteCascade(ProfileService profileService) {
        List<ProfileService> children = this.findChildren(profileService);
        for (ProfileService child : children) {
            this.deleteCascade(child);
        }
        this.propertyDAO.deleteByService(profileService);
        this.individualCounterConfigurationManager.deleteByService(profileService);
        this.profileCounterRelationDAO.deleteByProfileService(profileService.getId());
        this.thresholdDAO.deleteByService(profileService);
        super.delete((BaseEntity)profileService);
        this.profileServiceListeners.forEach(listener -> listener.onProfileServiceDeleted(profileService));
    }

    @Override
    public void registerListener(ProfileServiceListener profileServiceListener) {
        this.profileServiceListeners.add(profileServiceListener);
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return TABLE_SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected String getEntitySimpleName() {
        return ProfileService.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), resultSet.getInt(TableColumn.PERIODTYPE.name()), resultSet.getString(TableColumn.BALANCEREUSEABLE.name()), resultSet.getInt(TableColumn.PERIODLENGTH.name()), resultSet.getInt(TableColumn.STARTDAYINMONTH.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getLong(TableColumn.FK_PROFILE.name()), ProfileServiceDAOBean.getNullableLongFromResultSet((ResultSet)resultSet, (String)TableColumn.FK_PARENTSERVICE.name())};
        }
        return null;
    }

    public Class<? extends CryptoExtendedBaseEntityDAOBean> getDaoBeanForUpdateFpCli() {
        return ProfileServiceFPDAOBean.class;
    }

    private static enum TableColumn {
        ID,
        STARTDATETIME,
        ENDDATETIME,
        PERIODTYPE,
        BALANCEREUSEABLE,
        PERIODLENGTH,
        STARTDAYINMONTH,
        NAME,
        FK_PROFILE,
        FK_PARENTSERVICE,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

