/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReferenceDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReferenceListener;
import com.ericsson.em.emc.hierarchies.persistence.lazyload.LazyLoadProfileReference;
import com.ericsson.lwac.cache.Cache;
import com.ericsson.lwac.cache.CacheService;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import com.ericsson.lwac.deployer.ApplicationContext;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Updatable
@Singleton
@Validatable
@CryptoKeys(keyAliases={"hier.profilereference.S"})
public class ProfileReferenceDAOBean
extends CryptoExtendedBaseEntityDAOBean<LazyLoadProfileReference>
implements ProfileReferenceDAO {
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    static final String PROFILE_REFERENCE_FINGERPRINT_KEY = "hier.profilereference.S";
    private static final String DB_TABLENAME = "hier$profilereference";
    @Resource
    private CacheService cacheService;
    private Cache<Long, LazyLoadProfileReference> cache;
    @EJB
    private ProfileDAO profileDAO;
    @Resource
    private ApplicationContext applicationContext;
    private final List<ProfileReferenceListener> profileReferenceListeners = new CopyOnWriteArrayList<ProfileReferenceListener>();

    @PostConstruct
    public void postConstruct() {
        this.cache = this.cacheService.createCache(Long.class, LazyLoadProfileReference.class, true);
    }

    @Override
    public void registerListener(ProfileReferenceListener profileListener) {
        this.profileReferenceListeners.add(profileListener);
    }

    @Override
    public void removeListener(ProfileReferenceListener profileListener) {
        this.profileReferenceListeners.remove(profileListener);
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        LazyLoadProfileReference profileReference = (LazyLoadProfileReference)baseEntity;
        preparedStatement.setLong(TableColumn.fk_profile.index(), profileReference.getProfile().getId());
        return this.assignFingerprint(preparedStatement, TableColumn.fingerprint.index(), new Object[]{profileReference.getProfile().getId()});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        LazyLoadProfileReference profileReference = (LazyLoadProfileReference)baseEntity;
        long profileId = resultSet.getLong(TableColumn.fk_profile.name());
        profileReference.setProfile(this.profileDAO.find(profileId));
    }

    protected LazyLoadProfileReference createManagedEntity() {
        return new LazyLoadProfileReference(this.profileDAO);
    }

    @Override
    public LazyLoadProfileReference find(long id) {
        LazyLoadProfileReference result = this.cache.getByPrimaryId(id);
        if (result == null && (result = (LazyLoadProfileReference)this.find(this.getSelectStatement() + " where " + TableColumn.id.name() + " = ?", new Object[]{id})) != null) {
            this.cache.update(id, result);
        }
        return result;
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return DB_TABLENAME;
    }

    public String getSequenceName() {
        return this.getTableName() + "_seq";
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    @Override
    public ProfileReference create(Profile profile) {
        LazyLoadProfileReference profileReference = new LazyLoadProfileReference(profile, this.profileDAO);
        this.create(profileReference);
        this.cache.update(profileReference.getId(), profileReference);
        this.profileReferenceListeners.forEach(it -> it.onProfileReferenceCreated(profileReference));
        return profileReference;
    }

    @Override
    public void delete(ProfileReference profileReference) {
        this.delete(this.getDeleteStatement(), new Object[]{profileReference.getProfileReferenceId()});
        this.cache.remove(profileReference.getProfileReferenceId());
        this.profileReferenceListeners.forEach(it -> it.onProfileReferenceDelete(profileReference));
    }

    @Override
    public List<ProfileReference> findByProfile(Profile profile) {
        ArrayList<ProfileReference> references = new ArrayList<ProfileReference>();
        List list = this.findMultiple(this.getSelectStatement() + " where " + TableColumn.fk_profile.name() + " = ?", new Object[]{profile.getId()});
        for (LazyLoadProfileReference ref : list) {
            references.add(ref);
        }
        return references;
    }

    @Override
    public boolean isProfileInUse(Profile profile) {
        return this.find(this.getSelectStatement() + " where " + TableColumn.fk_profile.name() + "= ?", new Object[]{profile.getId()}) != null;
    }

    protected String getEntitySimpleName() {
        return LazyLoadProfileReference.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return PROFILE_REFERENCE_FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getLong(TableColumn.fk_profile.name())};
        }
        return null;
    }

    public LazyLoadProfileReference update(LazyLoadProfileReference entry) {
        return (LazyLoadProfileReference)super.update((BaseEntity)entry);
    }

    public LazyLoadProfileReference updateDefaultFingerprint(LazyLoadProfileReference entry) {
        return (LazyLoadProfileReference)this.updateWithFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        if (this.isDefaultData()) {
            return 0L;
        }
        return this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.fingerprintversion) + "= ? order by " + String.valueOf((Object)TableColumn.id) + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
    }

    private static enum TableColumn {
        id,
        fk_profile,
        fingerprint,
        fingerprintversion,
        fingerprintkeygeneration;


        int index() {
            return this.ordinal();
        }
    }
}

