/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.Property;
import com.ericsson.em.emc.m3externallog.json.JsonMapper;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.cache.Cacheable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.google.gson.annotations.SerializedName;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

@Entity
public class Profile
extends BaseEntity
implements Cacheable<Profile> {
    private static final long serialVersionUID = 1L;
    public static final double VERSION = 2.6;
    private String name;
    private List<ProfileService> profileServices = new LinkedList<ProfileService>();
    private static final int NAME_MAX_LENGTH = 64;
    private static final String PROPERTY_PROFILE_TYPE = "Profile Type";
    private static final String GENERAL_SERVICE_NAME = "General";
    @JsonMapper.NotMapped
    private long version = 1L;
    @SerializedName(value="version")
    private double profileVersion;

    public Profile() {
    }

    public Profile(String name) {
        this.name = name;
        this.profileVersion = 2.6;
    }

    protected Profile(Profile profile) {
        super((BaseEntity)profile);
        this.name = profile.getName();
        this.profileVersion = profile.getProfileVersion();
        this.profileServices = new LinkedList<ProfileService>();
        for (ProfileService profileService : profile.getServices()) {
            profileService = profileService.deepClone();
            this.profileServices.add(profileService);
            profileService.setProfile(this);
        }
    }

    @Column(unique=true, nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ProfileService> getServices() {
        return this.profileServices;
    }

    public void setServices(List<ProfileService> profileServices) {
        this.profileServices = profileServices;
    }

    public boolean hasProfileType(String profileType) {
        ProfileService generalService = this.findProfileService(GENERAL_SERVICE_NAME);
        if (generalService != null) {
            Predicate<Property> hasProfileType = p -> PROPERTY_PROFILE_TYPE.equals(p.getName()) && profileType.equals(p.getValue());
            return generalService.getProperties().stream().anyMatch(hasProfileType);
        }
        return false;
    }

    public String toString() {
        return "com.ericsson.mpah.hierarchies.persistence.Profile[id=" + this.mId + "]";
    }

    @Override
    public Profile deepClone() {
        Profile clone = new Profile(this);
        clone.setVersion(this.getVersion());
        return clone;
    }

    protected void validate() {
        if (this.name == null || this.name.isEmpty() || this.name.length() > 64) {
            throw new ValidationException("Invalid name length");
        }
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void increaseVersion() {
        ++this.version;
    }

    void setVersion(long version) {
        this.version = version;
    }

    public double getProfileVersion() {
        return this.profileVersion;
    }

    public void setProfileVersion(double profileVersion) {
        this.profileVersion = profileVersion;
    }

    private ProfileService findProfileService(String serviceName) {
        for (ProfileService profileService : this.getServices()) {
            ProfileService result = this.findProfileService(profileService, serviceName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private ProfileService findProfileService(ProfileService profileService, String serviceName) {
        if (serviceName.equals(profileService.getName())) {
            return profileService;
        }
        for (ProfileService childService : profileService.getChildren()) {
            ProfileService result = this.findProfileService(childService, serviceName);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

