/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.utilities.DateUtilities;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import org.joda.time.DateTime;

@MappedSuperclass
public abstract class Period
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected DateTime startDateTime;
    protected DateTime endDateTime;

    public Period() {
    }

    protected Period(Period period) {
        super((BaseEntity)period);
        this.startDateTime = period.getStartDateTime();
        this.endDateTime = period.getEndDateTime();
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public DateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(DateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public DateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(DateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public boolean within(DateTime date) {
        return DateUtilities.within(this.startDateTime, this.endDateTime, date);
    }
}

