/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.GlobalParameter;
import com.ericsson.em.emc.hierarchies.persistence.GlobalParameterDAO;
import com.ericsson.lwac.cache.Cache;
import com.ericsson.lwac.cache.CacheService;
import com.ericsson.lwac.cache.LockingType;
import com.ericsson.lwac.cache.SecondaryCache;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import com.ericsson.lwac.deployer.ApplicationContext;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Stream;

@Updatable
@Singleton
@Validatable
@CryptoKeys(keyAliases={"hier.globalparameter.S"})
public class GlobalParameterDAOBean
extends CryptoExtendedBaseEntityDAOBean<GlobalParameter>
implements GlobalParameterDAO {
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private CacheService cacheService;
    private Cache<Long, GlobalParameter> cache;
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    static final String FINGERPRINT_KEY = "hier.globalparameter.S";
    static final String DB_TABLENAME = "hier$globalparameter";

    public String[] getColumns() {
        return (String[])Stream.of(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return DB_TABLENAME;
    }

    public String getSequenceName() {
        return "hier$globalparameter_seq";
    }

    public boolean isVersionable() {
        return true;
    }

    public boolean isUpdatable() {
        return true;
    }

    @Override
    public GlobalParameter create(GlobalParameter globalParameter) {
        super.create((BaseEntity)globalParameter);
        this.updateCache(globalParameter);
        return globalParameter;
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        GlobalParameter globalParameter = (GlobalParameter)baseEntity;
        int i = 1;
        preparedStatement.setString(i++, globalParameter.getKey());
        preparedStatement.setString(i++, globalParameter.getValue());
        preparedStatement.setString(i++, globalParameter.getDataType());
        return this.assignFingerprint(preparedStatement, i, new Object[]{globalParameter.getKey(), globalParameter.getValue(), globalParameter.getDataType()});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        GlobalParameter globalParameter = (GlobalParameter)baseEntity;
        globalParameter.setKey(resultSet.getString(TableColumn.KEY.name()));
        globalParameter.setValue(resultSet.getString(TableColumn.VALUE.name()));
        globalParameter.setDataType(resultSet.getString(TableColumn.DATATYPE.name()));
        globalParameter.setVersion(resultSet.getLong(TableColumn.VERSION.name()));
    }

    protected GlobalParameter createManagedEntity() {
        return new GlobalParameter();
    }

    @Override
    public GlobalParameter update(GlobalParameter globalParameter) {
        this.updateCache(globalParameter);
        return (GlobalParameter)super.updateWithVersionCheck((BaseEntity)globalParameter);
    }

    @Override
    public GlobalParameter findByKey(String key) {
        GlobalParameter globalParameter = this.cache.getBySecondaryId(GlobalParameterSecondaryCache.KEY, key);
        if (globalParameter == null && (globalParameter = (GlobalParameter)this.find(this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.KEY) + " = ?", new Object[]{key})) != null) {
            this.updateCache(globalParameter);
        }
        return globalParameter;
    }

    @Override
    public List<GlobalParameter> findAll() {
        return this.findMultiple(this.getSelectStatement(), new Object[0]);
    }

    @PostConstruct
    public void postConstruct() {
        this.cache = this.cacheService.createCache(Long.class, GlobalParameter.class, false);
        this.cache.addSecondaryCache(GlobalParameterSecondaryCache.KEY);
    }

    protected void updateCache(GlobalParameter globalParameter) {
        this.cache.update(globalParameter.getId(), globalParameter, new SecondaryCache[]{GlobalParameterSecondaryCache.KEY}, new String[]{globalParameter.getKey()}, LockingType.optimistic);
    }

    protected String getEntitySimpleName() {
        return GlobalParameter.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getString(TableColumn.KEY.name()), resultSet.getString(TableColumn.VALUE.name()), resultSet.getString(TableColumn.DATATYPE.name())};
        }
        return null;
    }

    @Override
    public void updateCacheForAllValidGlobalParameters() {
        List globalParameters = this.findMultiple(this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.FINGERPRINTVERSION) + " = ?", new Object[]{2});
        globalParameters.stream().forEach(globalParameter -> this.updateCache((GlobalParameter)globalParameter));
    }

    public GlobalParameter updateDefaultFingerprint(GlobalParameter entry) {
        return (GlobalParameter)this.updateWithVersionAndFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        long recordsUpdated = this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.FINGERPRINTVERSION) + "= ? order by " + String.valueOf((Object)TableColumn.ID) + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
        return recordsUpdated;
    }

    private static enum TableColumn {
        ID,
        KEY,
        VALUE,
        DATATYPE,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION,
        VERSION;


        int index() {
            return this.ordinal();
        }
    }

    static enum GlobalParameterSecondaryCache implements SecondaryCache
    {
        KEY("key");

        private final String key;

        private GlobalParameterSecondaryCache(String key) {
            this.key = key;
        }

        @Override
        public String getName() {
            return this.key;
        }
    }
}

