/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.limits;

import com.ericsson.em.emc.hierarchies.limits.LimitMatchingParameters;
import com.ericsson.em.emc.hierarchies.persistence.MatchRule;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class LimitMatcher<T extends MatchRule<T>> {
    LimitMatcher() {
    }

    static <T extends MatchRule<T>> boolean isMatching(List<T> matchRules, LimitMatchingParameters matchingParameters) {
        return new LimitMatcher<T>().isMatchingInternal(matchRules, matchingParameters);
    }

    private boolean isMatchingInternal(List<T> matchRules, LimitMatchingParameters matchingParameters) {
        List<T> negativeRules = this.filterNegativeRulesFrom(matchRules);
        List<T> positiveRules = this.filterPositiveRulesFrom(matchRules);
        for (MatchRule rule : negativeRules) {
            if (!this.isMatchingRule(matchingParameters, rule)) continue;
            return false;
        }
        if (positiveRules.isEmpty()) {
            return true;
        }
        for (MatchRule rule : positiveRules) {
            if (!this.isMatchingRule(matchingParameters, rule)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchingRule(LimitMatchingParameters matchingParameters, T matchRule) {
        boolean isMatchingAnyParameter = false;
        if (matchingParameters.shallMatchOnOperationType()) {
            if (this.hasMatchingOperationType(matchRule, matchingParameters.getOperationType())) {
                isMatchingAnyParameter = true;
            } else {
                return false;
            }
        }
        for (Map.Entry<String, Predicate<String>> matcher : matchingParameters.getPropertyToMatchPredicates().entrySet()) {
            Optional<String> matchRuleProperty = ((MatchRule)matchRule).getProperty(matcher.getKey());
            if (!matchRuleProperty.isPresent()) continue;
            Predicate<String> matchingPredicate = matcher.getValue();
            if (matchingPredicate.test(matchRuleProperty.get())) {
                isMatchingAnyParameter = true;
                continue;
            }
            return false;
        }
        return isMatchingAnyParameter;
    }

    private boolean hasMatchingOperationType(T rule, String operationType) {
        return operationType.equalsIgnoreCase(((MatchRule)rule).getOperationType()) || ((MatchRule)rule).getOperationType().equals("*");
    }

    private List<T> filterPositiveRulesFrom(List<T> matchingRules) {
        return matchingRules.stream().filter(mr -> !mr.isExclusion()).collect(Collectors.toList());
    }

    private List<T> filterNegativeRulesFrom(List<T> matchRules) {
        return matchRules.stream().filter(MatchRule::isExclusion).collect(Collectors.toList());
    }
}

