/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.globalparameters;

import com.ericsson.em.emc.hierarchies.globalparameters.GlobalParameterManager;
import com.ericsson.em.emc.hierarchies.persistence.GlobalParameter;
import com.ericsson.em.emc.hierarchies.persistence.GlobalParameterDAO;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLog;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLogContext;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLogger;
import com.ericsson.lwac.cli.ExecutionException;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Singleton
public class GlobalParameterManagerBean
implements GlobalParameterManager {
    private static final Set<String> SHOULD_BE_SET_ONCE = new HashSet<String>(Arrays.asList("account.id.format", "bank.code"));
    @EJB
    private GlobalParameterDAO globalParameterDAO;

    @Override
    @RolesAllowed(value={"ROLE_GLOBAL_PARAMETERS_ADMIN"})
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ViewAuditTrailLogRecord", transactionType="ListGlobalParameters", flags={"forcelog"}, recordVersion=1)
    public List<GlobalParameter> list() {
        return this.globalParameterDAO.findAll();
    }

    @Override
    @RolesAllowed(value={"ROLE_GLOBAL_PARAMETERS_ADMIN"})
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ChangeAuditTrailLogRecord", transactionType="UpdateGlobalParameter", flags={"forcelog"}, recordVersion=1)
    public void update(String key, String value) throws ExecutionException {
        if (SHOULD_BE_SET_ONCE.contains(key)) {
            throw new ExecutionException(key + " cannot be updated. It is allowed to be set only once.");
        }
        AuditTrailLogger auditTrailLogger = AuditTrailLogContext.getLogger();
        GlobalParameter globalParameter = this.globalParameterDAO.findByKey(key);
        if (globalParameter == null) {
            throw new ExecutionException("Global parameter with key = " + key + " does not exist.");
        }
        String previousValue = this.createAuditTrailLogObject(globalParameter);
        globalParameter.setValue(value);
        globalParameter = this.globalParameterDAO.update(globalParameter);
        if (auditTrailLogger != null && auditTrailLogger.isLogEnable()) {
            auditTrailLogger.log("PreviousGlobalParameterValue", (Object)previousValue);
            auditTrailLogger.log("UpdatedGlobalParameterValue", (Object)this.createAuditTrailLogObject(globalParameter));
        }
    }

    @Override
    @RolesAllowed(value={"ROLE_GLOBAL_PARAMETERS_ADMIN"})
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ChangeAuditTrailLogRecord", transactionType="CreateGlobalParameter", flags={"forcelog"}, recordVersion=1)
    public void create(String key, String value, String dataType) throws ExecutionException {
        if (this.findByKey(key) != null) {
            throw new ExecutionException("Operation has been rejected. " + key + " is existed.");
        }
        GlobalParameter globalParameter = new GlobalParameter(key);
        globalParameter.setValue(value);
        globalParameter.setDataType(dataType);
        AuditTrailLogger auditTrailLogger = AuditTrailLogContext.getLogger();
        if (auditTrailLogger != null && auditTrailLogger.isLogEnable()) {
            auditTrailLogger.log("CreatedGlobalParameterValue", (Object)this.createAuditTrailLogObject(globalParameter));
        }
        this.globalParameterDAO.create(globalParameter);
    }

    @Override
    @RolesAllowed(value={"ROLE_GLOBAL_PARAMETERS_ADMIN"})
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ViewAuditTrailLogRecord", transactionType="ViewGlobalParameter", flags={"forcelog"}, recordVersion=1)
    public GlobalParameter findByKey(String key) {
        return this.globalParameterDAO.findByKey(key);
    }

    private String createAuditTrailLogObject(GlobalParameter globalParameter) {
        return globalParameter.getKey() + " = " + globalParameter.getValue();
    }
}

