/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.counters;

import com.ericsson.em.emc.hierarchies.counters.CounterTypeRegistry;
import com.ericsson.em.emc.hierarchies.limits.CounterType;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.google.common.collect.Maps;
import jakarta.ejb.Singleton;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;

@Singleton
public class CounterTypeRegistryBean
implements CounterTypeRegistry {
    private final Map<String, CounterType> registeredCounterTypes = Maps.newConcurrentMap();

    public CounterTypeRegistryBean() {
        this.registerCounterType(CounterConfiguration.NoCounterType.class);
    }

    @Override
    public <T extends Enum<T>> void registerCounterType(Class<T> counterTypeClass) {
        EnumSet<Enum> allValues = EnumSet.allOf(counterTypeClass);
        for (Enum value : allValues) {
            CounterType previousValue = this.registeredCounterTypes.putIfAbsent(((CounterType)((Object)value)).getName(), (CounterType)((Object)value));
            if (previousValue == null || previousValue == value) continue;
            throw new IllegalArgumentException("Key [" + ((CounterType)((Object)value)).getName() + "] is already registered by " + String.valueOf(previousValue.getClass()));
        }
    }

    @Override
    public Optional<CounterType> getCounterType(String counterTypeName) {
        return Optional.ofNullable(this.registeredCounterTypes.get(counterTypeName));
    }
}

